/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.identifiers;

import org.fcrepo.kernel.identifiers.InternalIdentifierConverter;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NamespaceConverter
extends InternalIdentifierConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(NamespaceConverter.class);

    protected String doForward(String inputId) {
        LOGGER.trace("Converting identifier {} from internal to external...", (Object)inputId);
        String result = inputId;
        for (String jcrNamespace : JcrRdfTools.jcrNamespacesToRDFNamespaces.keySet()) {
            LOGGER.trace("Replacing namespace: {} with: {}", (Object)jcrNamespace, JcrRdfTools.jcrNamespacesToRDFNamespaces.get((Object)jcrNamespace));
            result = result.replace(jcrNamespace, (CharSequence)JcrRdfTools.jcrNamespacesToRDFNamespaces.get((Object)jcrNamespace));
        }
        LOGGER.trace("Converted identifier {} from internal to external {}...", (Object)inputId, (Object)result);
        return result;
    }

    protected String doBackward(String b) {
        LOGGER.trace("Converting identifier from external to internal...");
        String result = b;
        for (String rdfNamespace : JcrRdfTools.rdfNamespacesToJcrNamespaces.keySet()) {
            LOGGER.trace("Replacing namespace: {} with: {}", (Object)rdfNamespace, JcrRdfTools.rdfNamespacesToJcrNamespaces.get((Object)rdfNamespace));
            result = result.replace(rdfNamespace, (CharSequence)JcrRdfTools.rdfNamespacesToJcrNamespaces.get((Object)rdfNamespace));
        }
        return result;
    }
}

