/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.observer.EventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilter
implements EventFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilter.class);
    private static final Function<NodeType, String> nodetype2string = new Function<NodeType, String>(){

        public String apply(NodeType input) {
            return input.getName();
        }
    };

    public Predicate<Event> getFilter(Session session) {
        return new DefaultFilter();
    }

    public boolean apply(Event event) {
        try {
            org.modeshape.jcr.api.observation.Event modeEvent = DefaultFilter.getJcr21Event(event);
            ImmutableList nodeTypes = ImmutableList.copyOf((Object[])modeEvent.getMixinNodeTypes());
            ImmutableSet mixinTypes = ImmutableSet.copyOf((Iterable)Iterables.transform((Iterable)nodeTypes, nodetype2string));
            return mixinTypes.contains("fedora:Resource") || mixinTypes.contains("fedora:Binary") || mixinTypes.contains("fedora:NonRdfSourceDescription") || mixinTypes.contains("fedora:Container");
        }
        catch (PathNotFoundException e) {
            LOGGER.trace("Dropping event from outside our assigned workspace:\n", (Throwable)e);
            return false;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static org.modeshape.jcr.api.observation.Event getJcr21Event(Event event) {
        try {
            return (org.modeshape.jcr.api.observation.Event)event;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(event + " is not a Modeshape Event");
        }
    }
}

