/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Converter;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.hp.hpl.jena.rdf.model.AnonId;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.nodetype.NodeTypeDefinition;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.NodeTypeTemplate;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.exception.ServerManagedPropertyException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.identifiers.PidMinter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.rdf.converters.PropertyConverter;
import org.fcrepo.kernel.impl.rdf.converters.ValueConverter;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.impl.utils.NodePropertiesTools;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.mint.UUIDPathMinter;
import org.modeshape.jcr.api.JcrTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrRdfTools {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrRdfTools.class);
    public static BiMap<String, String> jcrNamespacesToRDFNamespaces = ImmutableBiMap.of((Object)"http://www.jcp.org/jcr/1.0", (Object)"http://fedora.info/definitions/v4/repository#");
    public static BiMap<String, String> rdfNamespacesToJcrNamespaces = jcrNamespacesToRDFNamespaces.inverse();
    private final IdentifierConverter<Resource, FedoraResource> idTranslator;
    private final ValueConverter valueConverter;
    private final Session session;
    private final NodePropertiesTools nodePropertiesTools = new NodePropertiesTools();
    @VisibleForTesting
    protected JcrTools jcrTools = new JcrTools();
    private final Map<AnonId, Resource> skolemizedBnodeMap;
    private static final Model m = ModelFactory.createDefaultModel();
    private static final PidMinter pidMinter = new UUIDPathMinter();

    public JcrRdfTools(IdentifierConverter<Resource, FedoraResource> idTranslator, Session session) {
        this.idTranslator = idTranslator;
        this.session = session;
        this.valueConverter = new ValueConverter(session, (Converter<Resource, FedoraResource>)idTranslator);
        this.skolemizedBnodeMap = new HashMap<AnonId, Resource>();
    }

    public static String getJcrNamespaceForRDFNamespace(String rdfNamespaceUri) {
        if (rdfNamespacesToJcrNamespaces.containsKey((Object)rdfNamespaceUri)) {
            return (String)rdfNamespacesToJcrNamespaces.get((Object)rdfNamespaceUri);
        }
        return rdfNamespaceUri;
    }

    public static String getRDFNamespaceForJcrNamespace(String jcrNamespaceUri) {
        if (jcrNamespacesToRDFNamespaces.containsKey((Object)jcrNamespaceUri)) {
            return (String)jcrNamespacesToRDFNamespaces.get((Object)jcrNamespaceUri);
        }
        return jcrNamespaceUri;
    }

    public Value createValue(Node node, RDFNode data, String propertyName) throws RepositoryException {
        ValueFactory valueFactory = node.getSession().getValueFactory();
        return this.createValue(valueFactory, data, FedoraTypesUtils.getPropertyType(node, propertyName));
    }

    public Value createValue(ValueFactory valueFactory, RDFNode data, int type) throws RepositoryException {
        assert (valueFactory != null);
        if (type == 0 || type == 1) {
            return (Value)this.valueConverter.reverse().convert((Object)data);
        }
        if (type == 9 || type == 10) {
            if (!data.isURIResource()) {
                throw new ValueFormatException("Reference properties can only refer to URIs, not literals");
            }
            try {
                Node nodeFromGraphSubject = ((FedoraResource)this.idTranslator.convert((Object)data.asResource())).getNode();
                return valueFactory.createValue(nodeFromGraphSubject, type == 10);
            }
            catch (RepositoryRuntimeException e) {
                throw new MalformedRdfException("Unable to find referenced node", (Throwable)e);
            }
        }
        if (data.isResource()) {
            LOGGER.debug("Using default JCR value creation for RDF resource: {}", (Object)data);
            return valueFactory.createValue(data.asResource().getURI(), type);
        }
        LOGGER.debug("Using default JCR value creation for RDF literal: {}", (Object)data);
        return valueFactory.createValue(data.asLiteral().getString(), type);
    }

    public void addMixin(FedoraResource resource, Resource mixinResource, Map<String, String> namespaces) throws RepositoryException {
        String mixinName;
        Node node = resource.getNode();
        Session session = node.getSession();
        if (!this.repositoryHasType(session, mixinName = PropertyConverter.getPropertyNameFromPredicate(node, mixinResource, namespaces))) {
            NodeTypeManager mgr = session.getWorkspace().getNodeTypeManager();
            NodeTypeTemplate type = mgr.createNodeTypeTemplate();
            type.setName(mixinName);
            type.setMixin(true);
            type.setQueryable(true);
            mgr.registerNodeType((NodeTypeDefinition)type, false);
        }
        if (node.isNodeType(mixinName)) {
            LOGGER.trace("Subject {} is already a {}; skipping", (Object)node, (Object)mixinName);
            return;
        }
        if (!node.canAddMixin(mixinName)) {
            throw new MalformedRdfException("Could not persist triple containing type assertion: " + mixinResource.toString() + " because no such mixin/type can be added to this node: " + node.getPath() + "!");
        }
        LOGGER.debug("Adding mixin: {} to node: {}.", (Object)mixinName, (Object)node.getPath());
        node.addMixin(mixinName);
    }

    public void addProperty(FedoraResource resource, Property predicate, RDFNode value, Map<String, String> namespaces) throws RepositoryException {
        Node node = resource.getNode();
        if (RdfLexicon.isManagedPredicate.apply((Object)predicate)) {
            throw new ServerManagedPropertyException("Could not persist triple containing predicate " + predicate.toString() + " to node " + node.getPath());
        }
        String propertyName = PropertyConverter.getPropertyNameFromPredicate(node, (Resource)predicate, namespaces);
        if (value.isURIResource() && this.idTranslator.inDomain((Object)value.asResource()) && !FedoraTypesUtils.isReferenceProperty(node, propertyName)) {
            this.nodePropertiesTools.addReferencePlaceholders(this.idTranslator, node, propertyName, value.asResource());
        } else {
            Value v = this.createValue(node, value, propertyName);
            this.nodePropertiesTools.appendOrReplaceNodeProperty(node, propertyName, v);
        }
    }

    protected boolean repositoryHasType(Session session, String mixinName) throws RepositoryException {
        return session.getWorkspace().getNodeTypeManager().hasNodeType(mixinName);
    }

    public void removeMixin(FedoraResource resource, Resource mixinResource, Map<String, String> nsPrefixMap) throws RepositoryException {
        Node node = resource.getNode();
        String mixinName = PropertyConverter.getPropertyNameFromPredicate(node, mixinResource, nsPrefixMap);
        if (this.repositoryHasType(this.session, mixinName) && node.isNodeType(mixinName)) {
            node.removeMixin(mixinName);
        }
    }

    public void removeProperty(FedoraResource resource, Property predicate, RDFNode objectNode, Map<String, String> nsPrefixMap) throws RepositoryException {
        Node node = resource.getNode();
        String propertyName = PropertyConverter.getPropertyNameFromPredicate(node, (Resource)predicate, nsPrefixMap);
        if (RdfLexicon.isManagedPredicate.apply((Object)predicate)) {
            throw new ServerManagedPropertyException("Could not remove triple containing predicate " + predicate.toString() + " to node " + node.getPath());
        }
        if (objectNode.isURIResource() && this.idTranslator.inDomain((Object)objectNode.asResource()) && !FedoraTypesUtils.isReferenceProperty(node, propertyName)) {
            this.nodePropertiesTools.removeReferencePlaceholders(this.idTranslator, node, propertyName, objectNode.asResource());
        } else {
            Value v = this.createValue(node, objectNode, propertyName);
            this.nodePropertiesTools.removeNodeProperty(node, propertyName, v);
        }
    }

    public Statement skolemize(IdentifierConverter<Resource, FedoraResource> idTranslator, Statement t) throws RepositoryException {
        Statement skolemized = t;
        if (t.getSubject().isAnon()) {
            skolemized = m.createStatement(this.getSkolemizedResource(idTranslator, (RDFNode)skolemized.getSubject()), skolemized.getPredicate(), skolemized.getObject());
        } else if (idTranslator.inDomain((Object)t.getSubject()) && t.getSubject().getURI().contains("#")) {
            this.findOrCreateHashUri(idTranslator, t.getSubject());
        }
        if (t.getObject().isAnon()) {
            skolemized = m.createStatement(skolemized.getSubject(), skolemized.getPredicate(), (RDFNode)this.getSkolemizedResource(idTranslator, skolemized.getObject()));
        } else if (t.getObject().isResource() && idTranslator.inDomain((Object)t.getObject().asResource()) && t.getObject().asResource().getURI().contains("#")) {
            this.findOrCreateHashUri(idTranslator, t.getObject().asResource());
        }
        return skolemized;
    }

    private void findOrCreateHashUri(IdentifierConverter<Resource, FedoraResource> idTranslator, Resource s) throws RepositoryException {
        String absPath = idTranslator.asString((Object)s);
        if (!absPath.isEmpty() && !this.session.nodeExists(absPath)) {
            Node closestExistingAncestor = FedoraTypesUtils.getClosestExistingAncestor(this.session, absPath);
            Node orCreateNode = this.jcrTools.findOrCreateNode(this.session, absPath, "nt:folder");
            orCreateNode.addMixin("fedora:Resource");
            Node parent = orCreateNode.getParent();
            if (!parent.getName().equals("#")) {
                throw new AssertionError((Object)("Hash URI resource created with too much hierarchy: " + s));
            }
            if (!parent.equals(closestExistingAncestor) && !parent.getParent().equals(closestExistingAncestor)) {
                throw new PathNotFoundException("Unexpected request to create new resource " + s);
            }
            if (parent.isNew()) {
                parent.addMixin("fedora:Pairtree");
            }
        }
    }

    private Resource getSkolemizedResource(IdentifierConverter<Resource, FedoraResource> idTranslator, RDFNode resource) throws RepositoryException {
        AnonId id = resource.asResource().getId();
        if (!this.skolemizedBnodeMap.containsKey(id)) {
            this.jcrTools.findOrCreateNode(this.session, JcrRdfTools.skolemizedPrefix());
            String pid = pidMinter.mintPid();
            String path = JcrRdfTools.skolemizedPrefix() + pid;
            Node preexistingNode = FedoraTypesUtils.getClosestExistingAncestor(this.session, path);
            Node orCreateNode = this.jcrTools.findOrCreateNode(this.session, path);
            orCreateNode.addMixin("fedora:Blanknode");
            if (preexistingNode != null) {
                AbstractService.tagHierarchyWithPairtreeMixin(preexistingNode, orCreateNode);
            }
            Resource skolemizedSubject = (Resource)NodeResourceConverter.nodeToResource(idTranslator).convert((Object)orCreateNode);
            this.skolemizedBnodeMap.put(id, skolemizedSubject);
        }
        return this.skolemizedBnodeMap.get(id);
    }

    private static String skolemizedPrefix() {
        return "/.well-known/genid/";
    }
}

