/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChildrenRdfContext
extends NodeRdfContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChildrenRdfContext.class);

    public ChildrenRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        if (resource.getNode().hasNodes()) {
            LOGGER.trace("Found children of this resource.");
            this.concat(this.childrenContext());
        }
    }

    private Iterator<Triple> childrenContext() {
        Iterator niceChildren = this.resource().getChildren();
        return Iterators.concat((Iterator)Iterators.transform((Iterator)niceChildren, this.child2triples()));
    }

    private Function<FedoraResource, Iterator<Triple>> child2triples() {
        return new Function<FedoraResource, Iterator<Triple>>(){

            public Iterator<Triple> apply(FedoraResource child) {
                Node childSubject = child instanceof NonRdfSourceDescription ? ((Resource)ChildrenRdfContext.this.translator().reverse().convert((Object)((NonRdfSourceDescription)child).getDescribedResource())).asNode() : ((Resource)ChildrenRdfContext.this.translator().reverse().convert((Object)child)).asNode();
                LOGGER.trace("Creating triples for child node: {}", (Object)child);
                RdfStream childStream = new RdfStream();
                childStream.concat(Triple.create((Node)ChildrenRdfContext.this.subject(), (Node)RdfLexicon.CONTAINS.asNode(), (Node)childSubject));
                return childStream;
            }
        };
    }
}

