/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Converter;
import com.google.common.collect.Lists;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.HashConverter;
import org.fcrepo.kernel.impl.identifiers.NamespaceConverter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.models.FedoraResource;

public class DefaultIdentifierTranslator
extends IdentifierConverter<Resource, FedoraResource> {
    private static final NodeResourceConverter nodeResourceConverter = new NodeResourceConverter();
    public static final String RESOURCE_NAMESPACE = "info:fedora/";
    private final Session session;
    protected Converter<String, String> forward = DefaultIdentifierTranslator.identity();
    protected Converter<String, String> reverse = DefaultIdentifierTranslator.identity();
    private static final List<Converter<String, String>> minimalTranslationChain = Lists.newArrayList((Object[])new Converter[]{new NamespaceConverter(), new HashConverter()});

    public DefaultIdentifierTranslator(Session session) {
        this.session = session;
        this.setTranslationChain();
    }

    private void setTranslationChain() {
        for (Converter<String, String> converter : minimalTranslationChain) {
            this.forward = this.forward.andThen(converter);
        }
        for (Converter converter : Lists.reverse(minimalTranslationChain)) {
            this.reverse = this.reverse.andThen(converter.reverse());
        }
    }

    protected FedoraResource doForward(Resource subject) {
        try {
            if (!this.inDomain(subject)) {
                throw new RepositoryRuntimeException("Subject " + subject + " is not in this repository");
            }
            return (FedoraResource)nodeResourceConverter.convert(this.session.getNode(this.asString(subject)));
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    protected Resource doBackward(FedoraResource resource) {
        String absPath = resource.getPath();
        return this.toDomain(absPath);
    }

    public boolean inDomain(Resource subject) {
        return subject.isURIResource() && subject.getURI().startsWith(RESOURCE_NAMESPACE);
    }

    public Resource toDomain(String absPath) {
        String relativePath = absPath.startsWith("/") ? absPath.substring(1) : absPath;
        return ResourceFactory.createResource((String)(RESOURCE_NAMESPACE + (String)this.reverse.convert((Object)relativePath)));
    }

    public String asString(Resource subject) {
        if (!this.inDomain(subject)) {
            return null;
        }
        String path = subject.getURI().substring(RESOURCE_NAMESPACE.length() - 1);
        String absPath = (String)this.forward.convert((Object)path);
        if (absPath.isEmpty()) {
            return "/";
        }
        return absPath;
    }
}

