/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.converters.PropertyConverter;
import org.fcrepo.kernel.impl.rdf.converters.ValueConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyValueIterator;
import org.fcrepo.kernel.models.FedoraResource;

public class LdpIsMemberOfRdfContext
extends NodeRdfContext {
    private final ValueConverter valueConverter = new ValueConverter(this.session(), (Converter<Resource, FedoraResource>)this.translator());

    public LdpIsMemberOfRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        FedoraResource container = resource.getContainer();
        if (container != null && (container.hasType("ldp:DirectContainer") || container.hasType("ldp:IndirectContainer")) && container.hasProperty("ldp:isMemberOfRelation")) {
            this.concatIsMemberOfRelation(container);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void concatIsMemberOfRelation(FedoraResource container) throws RepositoryException {
        String insertedContainerProperty;
        Property property = container.getProperty("ldp:isMemberOfRelation");
        final Resource memberRelation = ResourceFactory.createResource((String)property.getString());
        final Resource membershipResource = this.getMemberResource(container);
        if (membershipResource == null) {
            return;
        }
        if (container.hasType("ldp:IndirectContainer")) {
            if (!container.hasProperty("ldp:insertedContentRelation")) return;
            insertedContainerProperty = container.getProperty("ldp:insertedContentRelation").getString();
        } else {
            insertedContainerProperty = RdfLexicon.MEMBER_SUBJECT.getURI();
        }
        if (insertedContainerProperty.equals(RdfLexicon.MEMBER_SUBJECT.getURI())) {
            this.concat(Triple.create((Node)this.subject(), (Node)memberRelation.asNode(), (Node)membershipResource.asNode()));
            return;
        } else {
            if (!container.hasType("ldp:IndirectContainer")) return;
            String insertedContentProperty = PropertyConverter.getPropertyNameFromPredicate(this.resource().getNode(), ResourceFactory.createResource((String)insertedContainerProperty), null);
            if (!this.resource().hasProperty(insertedContentProperty)) {
                return;
            }
            PropertyValueIterator values = new PropertyValueIterator(this.resource().getProperty(insertedContentProperty));
            UnmodifiableIterator insertedContentRelations = Iterators.filter((Iterator)Iterators.transform((Iterator)((Object)values), (Function)this.valueConverter), (Predicate)new Predicate<RDFNode>(){

                public boolean apply(RDFNode input) {
                    return input.isURIResource() && LdpIsMemberOfRdfContext.this.translator().inDomain((Object)input.asResource());
                }
            });
            this.concat(Iterators.transform((Iterator)insertedContentRelations, (Function)new Function<RDFNode, Triple>(){

                public Triple apply(RDFNode input) {
                    return Triple.create((Node)input.asNode(), (Node)memberRelation.asNode(), (Node)membershipResource.asNode());
                }
            }));
        }
    }

    private Resource getMemberResource(FedoraResource parent) throws RepositoryException {
        Property memberResource;
        int type;
        Resource membershipResource = parent.hasProperty("ldp:membershipResource") ? ((type = (memberResource = parent.getProperty("ldp:membershipResource")).getType()) == 9 || type == 10 || type == 8 ? (Resource)this.nodeConverter().convert((Object)memberResource.getNode()) : ResourceFactory.createResource((String)memberResource.getString())) : (Resource)this.translator().reverse().convert((Object)parent);
        return membershipResource;
    }
}

