/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl.mappings;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.datatypes.RDFDatatype;
import com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.impl.LiteralLabel;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.rdf.converters.PropertyConverter;
import org.fcrepo.kernel.impl.rdf.converters.ValueConverter;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyValueIterator;
import org.fcrepo.kernel.models.FedoraResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyToTriple
implements Function<Property, Iterator<Triple>> {
    private static final PropertyConverter propertyConverter = new PropertyConverter();
    private final ValueConverter valueConverter;
    private Converter<javax.jcr.Node, Resource> graphSubjects;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyToTriple.class);

    public PropertyToTriple(Session session, Converter<Resource, FedoraResource> graphSubjects) {
        this.valueConverter = new ValueConverter(session, graphSubjects);
        this.graphSubjects = NodeResourceConverter.nodeToResource(graphSubjects);
    }

    public Iterator<Triple> apply(final Property p) {
        return Iterators.transform((Iterator)((Object)new PropertyValueIterator(p)), (Function)new Function<Value, Triple>(){

            public Triple apply(Value v) {
                return PropertyToTriple.this.propertyvalue2triple(p, v);
            }
        });
    }

    private Triple propertyvalue2triple(Property p, Value v) {
        LOGGER.trace("Rendering triple for Property: {} with Value: {}", (Object)p, (Object)v);
        try {
            Triple triple = Triple.create((Node)((Resource)this.graphSubjects.convert((Object)p.getParent())).asNode(), (Node)((com.hp.hpl.jena.rdf.model.Property)propertyConverter.convert(p)).asNode(), (Node)this.convertObject(p, v));
            LOGGER.trace("Created triple: {} ", (Object)triple);
            return triple;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private Node convertObject(Property p, Value v) throws RepositoryException {
        LiteralLabel literal;
        String datatypeURI;
        String propertyName;
        int i;
        Node object = ((RDFNode)this.valueConverter.convert(v)).asNode();
        if (object.isLiteral() && (i = (propertyName = p.getName()).indexOf(64)) > 0 && ((datatypeURI = (literal = object.getLiteral()).getDatatypeURI()).isEmpty() || datatypeURI.equals(XSDDatatype.XSDstring.getURI()))) {
            String lang = propertyName.substring(i + 1);
            return NodeFactory.createLiteral((String)literal.getLexicalForm(), (String)lang, (RDFDatatype)literal.getDatatype());
        }
        return object;
    }
}

