/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.spring;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.spring.DefaultPropertiesLoader;
import org.modeshape.common.collection.Problem;
import org.modeshape.common.collection.Problems;
import org.modeshape.jcr.JcrRepository;
import org.modeshape.jcr.ModeShapeEngine;
import org.modeshape.jcr.NoSuchRepositoryException;
import org.modeshape.jcr.RepositoryConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.io.Resource;

public class ModeShapeRepositoryFactoryBean
implements FactoryBean<JcrRepository> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModeShapeRepositoryFactoryBean.class);
    private DefaultPropertiesLoader propertiesLoader;
    @Inject
    private ModeShapeEngine modeShapeEngine;
    private Resource repositoryConfiguration;
    private JcrRepository repository;

    @PostConstruct
    public void buildRepository() {
        try {
            LOGGER.info("Using repo config (classpath): {}", (Object)this.repositoryConfiguration.getURL());
            this.getPropertiesLoader().loadSystemProperties();
            RepositoryConfiguration config = RepositoryConfiguration.read(this.repositoryConfiguration.getURL());
            this.repository = this.modeShapeEngine.deploy(config);
            Problems problems = this.repository.getStartupProblems();
            for (Problem p : problems) {
                LOGGER.error("ModeShape Start Problem: {}", (Object)p.getMessageString());
            }
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    @PreDestroy
    public void stopRepository() throws InterruptedException {
        LOGGER.info("Initiating shutdown of ModeShape");
        String repoName = this.repository.getName();
        try {
            Future<Boolean> futureUndeployRepo = this.modeShapeEngine.undeploy(repoName);
            futureUndeployRepo.get();
            LOGGER.info("Repository {} undeployed.", (Object)repoName);
        }
        catch (NoSuchRepositoryException e) {
            LOGGER.error("Repository {} unknown, cannot undeploy.", (Object)repoName, (Object)e);
        }
        catch (ExecutionException e) {
            LOGGER.error("Repository {} cannot undeploy.", (Object)repoName, (Object)e);
        }
        Future<Boolean> futureShutdownEngine = this.modeShapeEngine.shutdown();
        try {
            if (futureShutdownEngine.get().booleanValue()) {
                LOGGER.info("ModeShape Engine has shutdown.");
            } else {
                LOGGER.error("ModeShape Engine shutdown failed without an exception, still running.");
            }
        }
        catch (ExecutionException e) {
            LOGGER.error("ModeShape Engine shutdown failed.", (Throwable)e);
        }
    }

    public JcrRepository getObject() {
        return this.repository;
    }

    public Class<?> getObjectType() {
        return JcrRepository.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void setRepositoryConfiguration(Resource repositoryConfiguration) {
        this.repositoryConfiguration = repositoryConfiguration;
    }

    private DefaultPropertiesLoader getPropertiesLoader() {
        if (null == this.propertiesLoader) {
            this.propertiesLoader = new DefaultPropertiesLoader();
        }
        return this.propertiesLoader;
    }
}

