/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.impl;

import com.google.common.collect.ImmutableSet;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.security.MessageDigest;
import java.util.Collection;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.fcrepo.kernel.impl.utils.FixityInputStream;
import org.fcrepo.kernel.impl.utils.FixityResultImpl;
import org.fcrepo.kernel.impl.utils.infinispan.CacheLoaderChunkInputStream;
import org.fcrepo.kernel.utils.ContentDigest;
import org.fcrepo.kernel.utils.FixityResult;
import org.infinispan.Cache;
import org.infinispan.CacheImpl;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.persistence.manager.PersistenceManager;
import org.infinispan.persistence.spi.CacheLoader;

public class DistributedFixityCheck
implements DistributedCallable<String, byte[], Collection<FixityResult>>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final String dataKey;
    private final String digest;
    private final int chunkSize;
    private final long length;
    private Cache<String, byte[]> cache;

    public DistributedFixityCheck(String dataKey, String digest, int chunkSize, long length) {
        this.dataKey = dataKey;
        this.digest = digest;
        this.chunkSize = chunkSize;
        this.length = length;
    }

    public Collection<FixityResult> call() throws Exception {
        ImmutableSet.Builder fixityResults = new ImmutableSet.Builder();
        for (CacheLoader store : this.stores()) {
            CacheLoaderChunkInputStream cacheLoaderChunkInputStream = new CacheLoaderChunkInputStream((CacheLoader<String, byte[]>)store, this.dataKey, this.chunkSize, this.length);
            Throwable throwable = null;
            try {
                FixityInputStream fixityInputStream = new FixityInputStream(cacheLoaderChunkInputStream, MessageDigest.getInstance(this.digest));
                Throwable throwable2 = null;
                try {
                    IOUtils.copy((InputStream)((Object)fixityInputStream), (OutputStream)NullOutputStream.NULL_OUTPUT_STREAM);
                    URI calculatedChecksum = ContentDigest.asURI((String)this.digest, (byte[])fixityInputStream.getMessageDigest().digest());
                    fixityResults.add((Object)new FixityResultImpl(this.getExternalIdentifier((CacheLoader<String, byte[]>)store), fixityInputStream.getByteCount(), calculatedChecksum));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    if (fixityInputStream == null) continue;
                    if (throwable2 != null) {
                        try {
                            fixityInputStream.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                        continue;
                    }
                    fixityInputStream.close();
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (cacheLoaderChunkInputStream == null) continue;
                if (throwable != null) {
                    try {
                        ((InputStream)cacheLoaderChunkInputStream).close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                ((InputStream)cacheLoaderChunkInputStream).close();
            }
        }
        return fixityResults.build();
    }

    private String getExternalIdentifier(CacheLoader<String, byte[]> store) {
        String address = this.cache.getCacheManager().getAddress() != null ? this.cache.getCacheManager().getAddress().toString() : "localhost";
        return "infinispan-cache-loader:" + address + "/" + store.toString() + "#" + this.dataKey;
    }

    public void setEnvironment(Cache<String, byte[]> cache, Set<String> inputKeys) {
        this.cache = cache;
    }

    private Set<CacheLoader> stores() {
        return ((PersistenceManager)((CacheImpl)this.cache).getComponentRegistry().getLocalComponent(PersistenceManager.class)).getStores(CacheLoader.class);
    }
}

