/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.infinispan;

import java.io.IOException;
import java.io.InputStream;
import org.infinispan.persistence.spi.CacheLoader;
import org.modeshape.common.logging.Logger;

public class CacheLoaderChunkInputStream
extends InputStream {
    private static final Logger LOGGER = Logger.getLogger(CacheLoaderChunkInputStream.class);
    private final CacheLoader<String, byte[]> blobCache;
    private final String key;
    private final int chunkSize;
    private final long totalSize;
    private final int chunksCount;
    protected int indexInBuffer;
    protected byte[] buffer;
    private int chunkNumber;

    public CacheLoaderChunkInputStream(CacheLoader<String, byte[]> blobCache, String key, int chunkSize, long totalSize) {
        this.blobCache = blobCache;
        this.key = key;
        this.chunkSize = chunkSize;
        this.totalSize = totalSize;
        this.chunkNumber = 0;
        this.indexInBuffer = 0;
        int remainderSize = (int)(totalSize % (long)chunkSize);
        int numberOfChunks = (int)totalSize / chunkSize;
        this.chunksCount = remainderSize > 0 ? numberOfChunks + 1 : numberOfChunks;
    }

    @Override
    public int read() throws IOException {
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null) {
            this.fillBufferWithFirstChunk();
            return this.read();
        }
        if (this.indexInBuffer >= this.buffer.length) {
            this.fillBufferWithNextChunk();
            return this.read();
        }
        return this.buffer[this.indexInBuffer++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.indexInBuffer == -1) {
            return -1;
        }
        if (this.buffer == null) {
            this.fillBufferWithFirstChunk();
            return this.read(b, off, len);
        }
        if (this.indexInBuffer >= this.buffer.length) {
            return -1;
        }
        int newlen = this.indexInBuffer + len > this.buffer.length ? this.buffer.length - this.indexInBuffer : len;
        System.arraycopy(this.buffer, this.indexInBuffer, b, off, newlen);
        this.indexInBuffer += newlen;
        if (this.indexInBuffer >= this.buffer.length) {
            this.fillBufferWithNextChunk();
        }
        return newlen;
    }

    @Override
    public int available() {
        if (this.buffer == null) {
            this.fillBufferWithFirstChunk();
        }
        return this.buffer.length - this.indexInBuffer;
    }

    @Override
    public final long skip(long n) {
        if (n <= 0L || this.indexInBuffer == -1 || this.totalSize == 0L) {
            return 0L;
        }
        return this.directSkip(n);
    }

    @Override
    public void close() {
        this.endOfStream();
    }

    private long directSkip(long n) {
        long availableInBuffer;
        long l = availableInBuffer = this.buffer != null ? (long)(this.buffer.length - this.indexInBuffer) : (long)this.chunkSize;
        if (n < availableInBuffer) {
            if (this.buffer == null) {
                this.fillBufferWithFirstChunk();
            }
            this.indexInBuffer = (int)((long)this.indexInBuffer + n);
            return n;
        }
        long lastChunkSize = this.totalSize - (long)((this.chunksCount - 1) * this.chunkSize);
        int chunksAvailableToSkip = this.chunksCount - this.chunkNumber - 1;
        long bytesAvailableToSkip = (long)((chunksAvailableToSkip - 1) * this.chunkSize) + lastChunkSize;
        long stillRequiredToSkip = n - availableInBuffer;
        int chunksToSkipOver = (int)(stillRequiredToSkip / (long)this.chunkSize);
        int leftToReadAfterSkip = (int)(stillRequiredToSkip % (long)this.chunkSize);
        this.chunkNumber = this.chunkNumber + chunksToSkipOver + 1;
        if (this.chunkNumber >= this.chunksCount) {
            this.endOfStream();
            return availableInBuffer + bytesAvailableToSkip;
        }
        this.fillBuffer(this.chunkNumber);
        if (this.buffer.length > leftToReadAfterSkip) {
            this.indexInBuffer = leftToReadAfterSkip;
            return n;
        }
        this.endOfStream();
        return availableInBuffer + bytesAvailableToSkip;
    }

    private void fillBufferWithNextChunk() {
        ++this.chunkNumber;
        this.fillBuffer(this.chunkNumber);
    }

    private void fillBufferWithFirstChunk() {
        this.fillBuffer(0);
    }

    private void fillBuffer(int chunkNumber) {
        this.buffer = this.readChunk(chunkNumber);
        if (this.buffer == null) {
            this.endOfStream();
        } else {
            this.indexInBuffer = 0;
        }
    }

    private void endOfStream() {
        this.buffer = new byte[0];
        this.indexInBuffer = -1;
        this.chunkNumber = -1;
    }

    private byte[] readChunk(int chunkNumber) {
        String chunkKey = this.key + "-" + chunkNumber;
        LOGGER.debug("Read chunk {0}", new Object[]{chunkKey});
        if (this.blobCache.contains((Object)chunkKey)) {
            return (byte[])this.blobCache.load((Object)chunkKey).getValue();
        }
        return null;
    }
}

