/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.util.CheckArg;
import org.modeshape.jcr.JcrI18n;
import org.modeshape.jcr.api.index.IndexColumnDefinitionTemplate;
import org.modeshape.jcr.value.PropertyType;

@Immutable
class RepositoryIndexColumnDefinitionTemplate
implements IndexColumnDefinitionTemplate {
    private String propertyName;
    private int columnType = 1;

    RepositoryIndexColumnDefinitionTemplate() {
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public IndexColumnDefinitionTemplate setPropertyName(String propertyName) {
        CheckArg.isNotNull((Object)propertyName, (String)"propertyName");
        this.propertyName = propertyName;
        return this;
    }

    public IndexColumnDefinitionTemplate setColumnType(int type) {
        CheckArg.isNotNull((Object)type, (String)"type");
        if (PropertyType.OBJECT == PropertyType.valueFor((int)type)) {
            throw new IllegalArgumentException(JcrI18n.invalidPropertyType.text(new Object[]{type}));
        }
        this.columnType = type;
        return this;
    }
}

