/*
 * Decompiled with CFR 0.152.
 */
package org.modeshape.jcr;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.modeshape.common.SystemFailureException;
import org.modeshape.common.annotation.Immutable;
import org.modeshape.common.annotation.ThreadSafe;
import org.modeshape.common.text.Inflector;
import org.modeshape.common.util.StringUtil;
import org.modeshape.jcr.ExecutionContext;
import org.modeshape.jcr.api.monitor.DurationActivity;
import org.modeshape.jcr.api.monitor.DurationMetric;
import org.modeshape.jcr.api.monitor.History;
import org.modeshape.jcr.api.monitor.RepositoryMonitor;
import org.modeshape.jcr.api.monitor.Statistics;
import org.modeshape.jcr.api.monitor.ValueMetric;
import org.modeshape.jcr.api.monitor.Window;
import org.modeshape.jcr.api.value.DateTime;
import org.modeshape.jcr.cache.change.Change;
import org.modeshape.jcr.cache.change.ChangeSet;
import org.modeshape.jcr.cache.change.ChangeSetListener;
import org.modeshape.jcr.cache.change.WorkspaceAdded;
import org.modeshape.jcr.cache.change.WorkspaceRemoved;
import org.modeshape.jcr.value.DateTimeFactory;

@ThreadSafe
public class RepositoryStatistics
implements RepositoryMonitor,
ChangeSetListener {
    public static final int MAXIMUM_LONG_RUNNING_QUERY_COUNT = 15;
    public static final int MAXIMUM_LONG_RUNNING_SEQUENCING_COUNT = 15;
    public static final int MAXIMUM_LONG_RUNNING_SESSION_COUNT = 15;
    public static final long CAPTURE_INTERVAL_IN_SECONDS = 5L;
    private static final long CAPTURE_DELAY_IN_SECONDS = 5L;
    protected static final long DURATION_OF_52_WEEKS_WINDOW_IN_SECONDS = TimeUnit.SECONDS.convert(52L, TimeUnit.DAYS) / 7L;
    protected static final long DURATION_OF_7_DAYS_WINDOW_IN_SECONDS = TimeUnit.SECONDS.convert(7L, TimeUnit.DAYS);
    protected static final long DURATION_OF_24_HOURS_WINDOW_IN_SECONDS = TimeUnit.SECONDS.convert(24L, TimeUnit.HOURS);
    protected static final long DURATION_OF_60_MINUTES_WINDOW_IN_SECONDS = TimeUnit.SECONDS.convert(60L, TimeUnit.MINUTES);
    protected static final long DURATION_OF_60_SECONDS_WINDOW_IN_SECONDS = TimeUnit.SECONDS.convert(60L, TimeUnit.SECONDS);
    private final ConcurrentMap<DurationMetric, DurationHistory> durations = new ConcurrentHashMap<DurationMetric, DurationHistory>();
    private final ConcurrentMap<ValueMetric, ValueHistory> values = new ConcurrentHashMap<ValueMetric, ValueHistory>();
    private final AtomicReference<ScheduledFuture<?>> rollupFuture = new AtomicReference();
    private final DateTimeFactory timeFactory;
    private final AtomicReference<DateTime> secondsStartTime = new AtomicReference();
    private final AtomicReference<DateTime> minutesStartTime = new AtomicReference();
    private final AtomicReference<DateTime> hoursStartTime = new AtomicReference();
    private final AtomicReference<DateTime> daysStartTime = new AtomicReference();
    private final AtomicReference<DateTime> weeksStartTime = new AtomicReference();
    private static final Statistics EMPTY_STATISTICS = new StatisticsImpl(0, 0L, 0L, 0.0, 0.0);

    RepositoryStatistics(ExecutionContext context) {
        this.timeFactory = context.getValueFactories().getDateFactory();
    }

    void start(ScheduledExecutorService service) {
        if (this.rollupFuture.get() != null) {
            return;
        }
        this.durations.put(DurationMetric.QUERY_EXECUTION_TIME, new DurationHistory(TimeUnit.MILLISECONDS, 15));
        this.durations.put(DurationMetric.SEQUENCER_EXECUTION_TIME, new DurationHistory(TimeUnit.MILLISECONDS, 15));
        this.durations.put(DurationMetric.SESSION_LIFETIME, new DurationHistory(TimeUnit.MILLISECONDS, 15));
        for (ValueMetric metric : EnumSet.allOf(ValueMetric.class)) {
            boolean resetUponRollup = !metric.isContinuous();
            this.values.put(metric, new ValueHistory(resetUponRollup));
        }
        DateTime now = this.timeFactory.create();
        this.weeksStartTime.compareAndSet(null, now);
        this.daysStartTime.compareAndSet(null, now);
        this.hoursStartTime.compareAndSet(null, now);
        this.minutesStartTime.compareAndSet(null, now);
        this.secondsStartTime.compareAndSet(null, now);
        this.rollup();
        this.rollupFuture.set(service.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                RepositoryStatistics.this.rollup();
            }
        }, 5L, 5L, TimeUnit.SECONDS));
    }

    void stop() {
        ScheduledFuture future = this.rollupFuture.getAndSet(null);
        if (future != null && !future.isDone() && !future.isCancelled()) {
            future.cancel(false);
        }
    }

    private void rollup() {
        DateTime now = this.timeFactory.create();
        Window largest = null;
        for (MetricHistory history : this.durations.values()) {
            largest = ((DurationHistory)history).rollup();
        }
        for (MetricHistory history : this.values.values()) {
            largest = ((ValueHistory)history).rollup();
        }
        if (largest == null) {
            return;
        }
        switch (largest) {
            case PREVIOUS_52_WEEKS: {
                this.weeksStartTime.set(now);
            }
            case PREVIOUS_7_DAYS: {
                this.daysStartTime.set(now);
            }
            case PREVIOUS_24_HOURS: {
                this.hoursStartTime.set(now);
            }
            case PREVIOUS_60_MINUTES: {
                this.minutesStartTime.set(now);
            }
            case PREVIOUS_60_SECONDS: {
                this.secondsStartTime.set(now);
            }
        }
    }

    private final DateTime mostRecentTimeFor(Window window) {
        switch (window) {
            case PREVIOUS_52_WEEKS: {
                return this.weeksStartTime.get();
            }
            case PREVIOUS_7_DAYS: {
                return this.daysStartTime.get();
            }
            case PREVIOUS_24_HOURS: {
                return this.hoursStartTime.get();
            }
            case PREVIOUS_60_MINUTES: {
                return this.minutesStartTime.get();
            }
            case PREVIOUS_60_SECONDS: {
                return this.secondsStartTime.get();
            }
        }
        throw new SystemFailureException("Should never happen");
    }

    public Set<DurationMetric> getAvailableDurationMetrics() {
        return RepositoryMonitor.ALL_DURATION_METRICS;
    }

    public Set<ValueMetric> getAvailableValueMetrics() {
        return RepositoryMonitor.ALL_VALUE_METRICS;
    }

    public Set<Window> getAvailableWindows() {
        return RepositoryMonitor.ALL_WINDOWS;
    }

    public History getHistory(ValueMetric metric, Window windowInTime) {
        assert (metric != null);
        assert (windowInTime != null);
        ValueHistory history = (ValueHistory)this.values.get(metric);
        Statistics[] stats = history != null ? history.getHistory(windowInTime) : Statistics.NO_STATISTICS;
        return new HistoryImpl(stats, this.mostRecentTimeFor(windowInTime), windowInTime);
    }

    public History getHistory(DurationMetric metric, Window windowInTime) {
        assert (metric != null);
        assert (windowInTime != null);
        DurationHistory history = (DurationHistory)this.durations.get(metric);
        Statistics[] stats = history != null ? history.getHistory(windowInTime) : Statistics.NO_STATISTICS;
        return new HistoryImpl(stats, this.mostRecentTimeFor(windowInTime), windowInTime);
    }

    public DurationActivity[] getLongestRunning(DurationMetric metric) {
        assert (metric != null);
        DurationHistory history = (DurationHistory)this.durations.get(metric);
        return history != null ? history.getLongestRunning() : DurationActivity.NO_DURATION_RECORDS;
    }

    void increment(ValueMetric metric, long incrementalValue) {
        assert (metric != null);
        ValueHistory history = (ValueHistory)this.values.get(metric);
        if (history != null) {
            history.recordIncrement(incrementalValue);
        }
    }

    void increment(ValueMetric metric) {
        assert (metric != null);
        ValueHistory history = (ValueHistory)this.values.get(metric);
        if (history != null) {
            history.recordIncrement(1L);
        }
    }

    void set(ValueMetric metric, long value) {
        assert (metric != null);
        ValueHistory history = (ValueHistory)this.values.get(metric);
        if (history != null) {
            history.recordNewValue(1L);
        }
    }

    void decrement(ValueMetric metric) {
        assert (metric != null);
        ValueHistory history = (ValueHistory)this.values.get(metric);
        if (history != null) {
            history.recordIncrement(-1L);
        }
    }

    void recordDuration(DurationMetric metric, long duration, TimeUnit timeUnit, Map<String, String> payload) {
        assert (metric != null);
        DurationHistory history = (DurationHistory)this.durations.get(metric);
        if (history != null) {
            history.recordDuration(duration, timeUnit, payload);
        }
    }

    public void notify(ChangeSet changeSet) {
        this.increment(ValueMetric.NODE_CHANGES, changeSet.changedNodes().size());
        if (changeSet.getWorkspaceName() == null) {
            for (Change change : changeSet) {
                if (change instanceof WorkspaceAdded) {
                    this.increment(ValueMetric.WORKSPACE_COUNT);
                    continue;
                }
                if (!(change instanceof WorkspaceRemoved)) continue;
                this.decrement(ValueMetric.WORKSPACE_COUNT);
            }
        }
    }

    public static Statistics statisticsFor(long value) {
        return new StatisticsImpl(1, value, value, value, 0.0);
    }

    public static Statistics statisticsFor(long[] values) {
        int length = values.length;
        if (length == 0) {
            return EMPTY_STATISTICS;
        }
        if (length == 1) {
            return RepositoryStatistics.statisticsFor(values[0]);
        }
        long total = 0L;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        for (long value : values) {
            total += value;
            max = Math.max(max, value);
            min = Math.min(min, value);
        }
        double mean = (double)total / (double)length;
        double varianceSquared = 0.0;
        double distance = 0.0;
        for (long value : values) {
            distance = mean - (double)value;
            varianceSquared += distance * distance;
        }
        return new StatisticsImpl(length, min, max, mean, Math.sqrt(varianceSquared));
    }

    public static Statistics statisticsFor(Statistics[] statistics) {
        int length = statistics.length;
        if (length == 0) {
            return EMPTY_STATISTICS;
        }
        if (length == 1) {
            return statistics[0] != null ? statistics[0] : EMPTY_STATISTICS;
        }
        int count = 0;
        long max = Long.MIN_VALUE;
        long min = Long.MAX_VALUE;
        double mean = 0.0;
        double variance = 0.0;
        for (Statistics stat : statistics) {
            if (stat == null) continue;
            count += stat.getCount();
            max = Math.max(max, stat.getMaximum());
            min = Math.min(min, stat.getMinimum());
            mean += stat.getMean() * (double)stat.getCount();
        }
        mean /= (double)count;
        double meanDelta = 0.0;
        for (Statistics stat : statistics) {
            if (stat == null) continue;
            meanDelta = stat.getMean() - mean;
            variance += (double)stat.getCount() * (stat.getVariance() + meanDelta * meanDelta);
        }
        return new StatisticsImpl(count, min, max, mean, variance);
    }

    @Immutable
    static final class HistoryImpl
    implements History {
        private final Statistics[] stats;
        private final DateTime endTime;
        private final Window window;

        protected HistoryImpl(Statistics[] stats, DateTime endTime, Window window) {
            this.stats = stats;
            this.endTime = endTime;
            this.window = window;
        }

        public Window getWindow() {
            return this.window;
        }

        public long getTotalDuration(TimeUnit unit) {
            if (unit == null) {
                unit = TimeUnit.SECONDS;
            }
            switch (this.window) {
                case PREVIOUS_52_WEEKS: {
                    return unit.convert(DURATION_OF_52_WEEKS_WINDOW_IN_SECONDS, TimeUnit.SECONDS);
                }
                case PREVIOUS_7_DAYS: {
                    return unit.convert(DURATION_OF_7_DAYS_WINDOW_IN_SECONDS, TimeUnit.SECONDS);
                }
                case PREVIOUS_24_HOURS: {
                    return unit.convert(DURATION_OF_24_HOURS_WINDOW_IN_SECONDS, TimeUnit.SECONDS);
                }
                case PREVIOUS_60_MINUTES: {
                    return unit.convert(DURATION_OF_60_MINUTES_WINDOW_IN_SECONDS, TimeUnit.SECONDS);
                }
                case PREVIOUS_60_SECONDS: {
                    return unit.convert(DURATION_OF_60_SECONDS_WINDOW_IN_SECONDS, TimeUnit.SECONDS);
                }
            }
            throw new SystemFailureException("Should never happen");
        }

        public DateTime getStartTime() {
            return this.endTime.minus(this.getTotalDuration(TimeUnit.SECONDS), TimeUnit.SECONDS);
        }

        public DateTime getEndTime() {
            return this.endTime;
        }

        public Statistics[] getStats() {
            return this.stats;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            long width = 0L;
            switch (this.window) {
                case PREVIOUS_52_WEEKS: {
                    sb.append("Previous 52 weeks");
                    width = TimeUnit.SECONDS.convert(7L, TimeUnit.DAYS);
                    break;
                }
                case PREVIOUS_7_DAYS: {
                    sb.append("Previous 7 days");
                    width = TimeUnit.SECONDS.convert(1L, TimeUnit.DAYS);
                    break;
                }
                case PREVIOUS_24_HOURS: {
                    sb.append("Previous 24 hours");
                    width = TimeUnit.SECONDS.convert(1L, TimeUnit.HOURS);
                    break;
                }
                case PREVIOUS_60_MINUTES: {
                    sb.append("Previous 60 minutes");
                    width = TimeUnit.SECONDS.convert(1L, TimeUnit.MINUTES);
                    break;
                }
                case PREVIOUS_60_SECONDS: {
                    sb.append("Previous 60 seconds");
                    width = TimeUnit.SECONDS.convert(5L, TimeUnit.SECONDS);
                }
            }
            DateTime startTime = this.getStartTime();
            sb.append(", starting at ");
            sb.append(startTime);
            sb.append(" and ending at ");
            sb.append(this.getEndTime());
            int i = 0;
            for (Statistics stat : this.stats) {
                ++i;
                if (stat == null) continue;
                sb.append("\n  ");
                sb.append(stat);
                sb.append("  at  ");
                sb.append(startTime.plus((long)i * width, TimeUnit.SECONDS));
            }
            return sb.toString();
        }
    }

    @Immutable
    static final class StatisticsImpl
    implements Statistics {
        private final int count;
        private final long maximum;
        private final long minimum;
        private final double mean;
        private final double variance;

        protected StatisticsImpl(int count, long min, long max, double mean, double variance) {
            this.count = count;
            this.maximum = max;
            this.minimum = min;
            this.mean = mean;
            this.variance = variance;
        }

        public int getCount() {
            return this.count;
        }

        public long getMaximum() {
            return this.maximum;
        }

        public long getMinimum() {
            return this.minimum;
        }

        public double getMean() {
            return this.mean;
        }

        public double getVariance() {
            return this.variance;
        }

        public double getStandardDeviation() {
            return this.variance <= 0.0 ? 0.0 : Math.sqrt(this.variance);
        }

        public String toString() {
            long count = this.getCount();
            String samples = Inflector.getInstance().pluralize((Object)"sample", count > 1L ? 2 : 1);
            return StringUtil.createString((String)"{0} {1}: min={2}; avg={3}; max={4}; dev={5}", (Object[])new Object[]{count, samples, this.minimum, this.mean, this.maximum, this.getStandardDeviation()});
        }
    }

    @ThreadSafe
    protected static final class DurationHistory
    extends MetricHistory {
        private final Queue<DurationActivity> duration1 = new ConcurrentLinkedQueue<DurationActivity>();
        private final Queue<DurationActivity> duration2 = new ConcurrentLinkedQueue<DurationActivity>();
        private final AtomicReference<Queue<DurationActivity>> durations = new AtomicReference();
        private final TimeUnit timeUnit;
        private final int retentionSize;
        private final PriorityBlockingQueue<DurationActivity> largestDurations;

        protected DurationHistory(TimeUnit timeUnit, int retentionSize) {
            assert (retentionSize > 0);
            this.durations.set(this.duration1);
            this.timeUnit = timeUnit;
            this.retentionSize = retentionSize;
            this.largestDurations = new PriorityBlockingQueue(this.retentionSize + 5);
        }

        void recordDuration(long value, TimeUnit timeUnit, Map<String, String> payload) {
            value = this.timeUnit.convert(value, timeUnit);
            this.durations.get().add(new DurationActivityImpl(value, this.timeUnit, payload));
        }

        @Override
        Window rollup() {
            Queue<DurationActivity> durations = null;
            if (this.durations.weakCompareAndSet(this.duration1, this.duration2)) {
                durations = this.duration1;
            } else {
                this.durations.weakCompareAndSet(this.duration2, this.duration1);
                durations = this.duration2;
            }
            ArrayList<DurationActivity> records = new ArrayList<DurationActivity>(durations);
            durations.clear();
            int numRecords = records.size();
            long[] values = new long[numRecords];
            int i = 0;
            for (DurationActivity record : records) {
                values[i++] = record != null ? record.getDuration(TimeUnit.MILLISECONDS) : 0L;
                this.largestDurations.add(record);
                while (this.largestDurations.size() > this.retentionSize) {
                    this.largestDurations.poll();
                }
            }
            Statistics stats = RepositoryStatistics.statisticsFor(values);
            return this.recordStatisticsForLastSecond(stats);
        }

        DurationActivity[] getLongestRunning() {
            ArrayList<DurationActivity> records = new ArrayList<DurationActivity>(this.largestDurations);
            return records.toArray(new DurationActivity[records.size()]);
        }
    }

    @Immutable
    public static final class DurationActivityImpl
    implements DurationActivity {
        protected final long duration;
        protected final Map<String, String> payload;
        protected final TimeUnit timeUnit;

        protected DurationActivityImpl(long duration, TimeUnit timeUnit, Map<String, String> payload) {
            this.duration = duration;
            this.payload = payload;
            this.timeUnit = timeUnit;
        }

        public long getDuration(TimeUnit unit) {
            return unit.convert(this.duration, this.timeUnit);
        }

        public Map<String, String> getPayload() {
            return this.payload;
        }

        public int compareTo(DurationActivity that) {
            if (this == that) {
                return 0;
            }
            return (int)(this.duration - that.getDuration(this.timeUnit));
        }

        public String toString() {
            return "Duration: " + this.getDuration(TimeUnit.SECONDS) + " sec, " + this.payload;
        }
    }

    @ThreadSafe
    protected static final class ValueHistory
    extends MetricHistory {
        private final AtomicLong value = new AtomicLong();
        private final boolean resetCounterUponRollup;

        protected ValueHistory(boolean resetCounterUponRollup) {
            this.resetCounterUponRollup = resetCounterUponRollup;
        }

        void recordIncrement(long increment) {
            this.value.addAndGet(increment);
        }

        void recordNewValue(long value) {
            this.value.set(value);
        }

        @Override
        Window rollup() {
            long value = this.resetCounterUponRollup ? this.value.getAndSet(0L) : this.value.get();
            return this.recordStatisticsForLastSecond(RepositoryStatistics.statisticsFor(value));
        }
    }

    @ThreadSafe
    protected static abstract class MetricHistory {
        protected static final int MAX_SECONDS = 12;
        protected static final int MAX_MINUTES = 60;
        protected static final int MAX_HOURS = 24;
        protected static final int MAX_DAYS = 7;
        protected static final int MAX_WEEKS = 52;
        private final Statistics[] seconds = new Statistics[12];
        private final Statistics[] minutes = new Statistics[60];
        private final Statistics[] hours = new Statistics[24];
        private final Statistics[] days = new Statistics[7];
        private final Statistics[] weeks = new Statistics[52];
        private int currentSecond = 0;
        private int currentMinute = 0;
        private int currentHour = 0;
        private int currentDay = 0;
        private int currentWeek = 0;
        private final ReadWriteLock lock = new ReentrantReadWriteLock(false);

        protected MetricHistory() {
        }

        abstract Window rollup();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Window recordStatisticsForLastSecond(Statistics stats) {
            Lock lock = this.lock.writeLock();
            try {
                lock.lock();
                this.seconds[this.currentSecond++] = stats;
                if (this.currentSecond == 12) {
                    this.currentSecond = 0;
                    Statistics cumulative = RepositoryStatistics.statisticsFor(this.seconds);
                    this.minutes[this.currentMinute++] = cumulative;
                    if (this.currentMinute == 60) {
                        this.currentMinute = 0;
                        cumulative = RepositoryStatistics.statisticsFor(this.minutes);
                        this.hours[this.currentHour++] = cumulative;
                        if (this.currentHour == 24) {
                            this.currentHour = 0;
                            cumulative = RepositoryStatistics.statisticsFor(this.hours);
                            this.days[this.currentDay++] = cumulative;
                            if (this.currentDay == 7) {
                                this.currentDay = 0;
                                cumulative = RepositoryStatistics.statisticsFor(this.days);
                                this.weeks[this.currentWeek++] = cumulative;
                                if (this.currentWeek == 52) {
                                    this.currentWeek = 0;
                                }
                                Window window = Window.PREVIOUS_52_WEEKS;
                                return window;
                            }
                            Window window = Window.PREVIOUS_7_DAYS;
                            return window;
                        }
                        Window window = Window.PREVIOUS_24_HOURS;
                        return window;
                    }
                    Window window = Window.PREVIOUS_60_MINUTES;
                    return window;
                }
                Window window = Window.PREVIOUS_60_SECONDS;
                return window;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Statistics[] getHistory(Window window) {
            Lock lock = this.lock.readLock();
            try {
                lock.lock();
                switch (window) {
                    case PREVIOUS_60_SECONDS: {
                        Statistics[] statisticsArray = this.copyStatistics(this.seconds, this.currentSecond);
                        return statisticsArray;
                    }
                    case PREVIOUS_60_MINUTES: {
                        Statistics[] statisticsArray = this.copyStatistics(this.minutes, this.currentMinute);
                        return statisticsArray;
                    }
                    case PREVIOUS_24_HOURS: {
                        Statistics[] statisticsArray = this.copyStatistics(this.hours, this.currentHour);
                        return statisticsArray;
                    }
                    case PREVIOUS_7_DAYS: {
                        Statistics[] statisticsArray = this.copyStatistics(this.days, this.currentDay);
                        return statisticsArray;
                    }
                    case PREVIOUS_52_WEEKS: {
                        Statistics[] statisticsArray = this.copyStatistics(this.weeks, this.currentWeek);
                        return statisticsArray;
                    }
                }
                Statistics[] statisticsArray = null;
                return statisticsArray;
            }
            finally {
                lock.unlock();
            }
        }

        private final Statistics[] copyStatistics(Statistics[] stats, int startingIndex) {
            int size = stats.length;
            Statistics[] results = new Statistics[size];
            if (startingIndex == 0) {
                System.arraycopy(stats, 0, results, 0, size);
            } else {
                int numAfterStartingIndex = size - startingIndex;
                int numBeforeStartingIndex = size - numAfterStartingIndex;
                if (numAfterStartingIndex > 0) {
                    System.arraycopy(stats, startingIndex, results, 0, numAfterStartingIndex);
                }
                if (numBeforeStartingIndex > 0) {
                    System.arraycopy(stats, 0, results, numAfterStartingIndex, numBeforeStartingIndex);
                }
            }
            return results;
        }
    }
}

