/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.observer;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.exception.InvalidChecksumException;
import org.fcrepo.kernel.impl.FedoraBinaryImpl;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.utils.ContentDigest;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.modeshape.jcr.api.Binary;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.ValueFactory;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/eventing.xml", "/spring-test/repo.xml"})
public class SimpleObserverIT
extends AbstractIT {
    private Integer eventBusMessageCount;
    @Inject
    private Repository repository;
    @Inject
    private EventBus eventBus;

    @Test
    public void TestEventBusPublishing() throws RepositoryException {
        Session se = this.repository.login();
        se.getRootNode().addNode("/object1").addMixin("fedora:Container");
        se.getRootNode().addNode("/object2").addMixin("fedora:Container");
        se.save();
        se.logout();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((String)"Where are my messages!?", (Object)2, (Object)this.eventBusMessageCount);
    }

    @Test
    public void contentEventCollapsing() throws RepositoryException, InvalidChecksumException {
        Session se = this.repository.login();
        JcrTools jcrTools = new JcrTools();
        Node n = jcrTools.findOrCreateNode(se.getRootNode(), "/object3", "nt:folder", "nt:file");
        n.addMixin("fedora:Resource");
        String content = "test content";
        String checksum = "1eebdf4fdc9fc7bf283031b93f9aef3338de9052";
        Binary bin = ((ValueFactory)se.getValueFactory()).createBinary((InputStream)new ByteArrayInputStream("test content".getBytes()), null);
        Node contentNode = jcrTools.findOrCreateChild(n, "jcr:content", "nt:resource");
        contentNode.addMixin("fedora:Binary");
        FedoraBinaryImpl binary = new FedoraBinaryImpl(contentNode);
        binary.setContent((InputStream)new ByteArrayInputStream("test content".getBytes()), "text/plain", ContentDigest.asURI((String)"SHA-1", (String)"1eebdf4fdc9fc7bf283031b93f9aef3338de9052"), "text.txt", null);
        se.save();
        se.logout();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Assert.assertEquals((String)"Node and content events not collapsed!", (Object)1, (Object)this.eventBusMessageCount);
    }

    @Subscribe
    public void countMessages(FedoraEvent e) {
        Integer n = this.eventBusMessageCount;
        Integer n2 = this.eventBusMessageCount = Integer.valueOf(this.eventBusMessageCount + 1);
        Set properties = e.getProperties();
        Assert.assertNotNull((Object)properties);
        String expected = "http://fedora.info/definitions/v4/repository#mixinTypes";
        Assert.assertTrue((String)("Should contain: http://fedora.info/definitions/v4/repository#mixinTypes" + properties), (boolean)properties.contains("http://fedora.info/definitions/v4/repository#mixinTypes"));
    }

    @Before
    public void acquireConnections() {
        this.eventBusMessageCount = 0;
        this.eventBus.register((Object)this);
    }

    @After
    public void releaseConnections() {
        this.eventBus.unregister((Object)this);
    }
}

