/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.integration.kernel.impl.observer;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import com.jayway.awaitility.Awaitility;
import com.jayway.awaitility.Duration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import javax.jcr.Node;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.integration.kernel.impl.AbstractIT;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(value={"/spring-test/eventing-suppress.xml", "/spring-test/repo.xml"})
public class SuppressByMixinFilterIT
extends AbstractIT {
    private static final long TIMEOUT = 20000L;
    @Inject
    private Repository repository;
    @Inject
    private EventBus eventBus;
    private Set<String> eventsReceived = new HashSet<String>();

    @Test(timeout=20000L)
    public void shouldSuppressWithMixin() throws RepositoryException {
        Session se = this.repository.login();
        try {
            Node node = se.getRootNode().addNode("/object1");
            node.addMixin("fedora:Container");
            node.addMixin("ldp:DirectContainer");
            se.getRootNode().addNode("/object2").addMixin("fedora:Container");
            se.save();
            this.waitForEvent("/object2");
            Assert.assertFalse((String)"Event not suppressed!", (boolean)this.eventsReceived.contains("/object1"));
        }
        catch (RepositoryException e) {
            se.logout();
        }
    }

    @Test(timeout=20000L)
    public void shouldAllowWithoutMixin() throws RepositoryException {
        Session se = this.repository.login();
        try {
            se.getRootNode().addNode("/object3").addMixin("fedora:Container");
            se.save();
            this.waitForEvent("/object3");
        }
        catch (RepositoryException e) {
            se.logout();
        }
    }

    @Before
    public void acquireConnections() {
        this.eventBus.register((Object)this);
    }

    @After
    public void releaseConnections() {
        this.eventBus.unregister((Object)this);
    }

    @Subscribe
    public void receiveEvents(FedoraEvent e) throws RepositoryException {
        Set properties = e.getProperties();
        Assert.assertNotNull((Object)properties);
        String expected = "http://fedora.info/definitions/v4/repository#mixinTypes";
        Assert.assertTrue((String)("Should contain: http://fedora.info/definitions/v4/repository#mixinTypes" + properties), (boolean)properties.contains("http://fedora.info/definitions/v4/repository#mixinTypes"));
        this.eventsReceived.add(e.getPath());
    }

    private void waitForEvent(final String id) {
        Awaitility.await().pollInterval(Duration.ONE_SECOND).until((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() {
                return SuppressByMixinFilterIT.this.eventsReceived.contains(id);
            }
        });
    }
}

