/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import com.google.common.base.Predicate;
import java.util.Calendar;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.FedoraJcrTypes;
import org.fcrepo.kernel.impl.ContainerImpl;
import org.fcrepo.kernel.models.Container;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class ContainerImplTest
implements FedoraJcrTypes {
    private static final String testPid = "testObj";
    private static final String mockUser = "mockUser";
    @Mock
    private Session mockSession;
    @Mock
    private Node mockRootNode;
    @Mock
    private Node mockObjNode;
    @Mock
    private Property mockProp;
    @Mock
    private Predicate<Node> mockPredicate;
    private Container testContainer;
    private NodeType[] mockNodetypes;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        String relPath = "/testObj";
        NodeType[] types = new NodeType[]{};
        try {
            Mockito.when((Object)this.mockObjNode.getName()).thenReturn((Object)testPid);
            Mockito.when((Object)this.mockObjNode.getSession()).thenReturn((Object)this.mockSession);
            Mockito.when((Object)this.mockObjNode.getMixinNodeTypes()).thenReturn((Object)types);
            NodeType mockNodeType = (NodeType)Mockito.mock(NodeType.class);
            Mockito.when((Object)mockNodeType.getName()).thenReturn((Object)"nt:folder");
            Mockito.when((Object)this.mockObjNode.getPrimaryNodeType()).thenReturn((Object)mockNodeType);
            Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRootNode);
            Mockito.when((Object)this.mockRootNode.getNode("/testObj")).thenReturn((Object)this.mockObjNode);
            Mockito.when((Object)this.mockSession.getUserID()).thenReturn((Object)mockUser);
            this.testContainer = new ContainerImpl(this.mockObjNode);
            this.mockNodetypes = new NodeType[2];
            this.mockNodetypes[0] = (NodeType)Mockito.mock(NodeType.class);
            Mockito.when((Object)this.mockNodetypes[0].getName()).thenReturn((Object)"some:type");
            this.mockNodetypes[1] = (NodeType)Mockito.mock(NodeType.class);
            Mockito.when((Object)this.mockObjNode.isNodeType("some:type")).thenReturn((Object)true);
            Mockito.when((Object)this.mockObjNode.getMixinNodeTypes()).thenReturn((Object)this.mockNodetypes);
            Mockito.when((Object)this.mockPredicate.apply((Object)this.mockObjNode)).thenReturn((Object)true);
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @After
    public void tearDown() {
        this.mockSession = null;
        this.mockRootNode = null;
        this.mockObjNode = null;
    }

    @Test
    public void testGetNode() {
        Assert.assertEquals((Object)this.testContainer.getNode(), (Object)this.mockObjNode);
    }

    @Test
    public void testGetCreated() throws RepositoryException {
        Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)Calendar.getInstance());
        Mockito.when((Object)this.mockObjNode.hasProperty("jcr:created")).thenReturn((Object)true);
        Mockito.when((Object)this.mockObjNode.getProperty("jcr:created")).thenReturn((Object)this.mockProp);
        this.testContainer.getCreatedDate();
        ((Node)Mockito.verify((Object)this.mockObjNode)).getProperty("jcr:created");
    }

    @Test
    public void testGetLastModified() throws RepositoryException {
        Mockito.when((Object)this.mockObjNode.hasProperty("jcr:lastModified")).thenReturn((Object)true);
        Mockito.when((Object)this.mockObjNode.getProperty("jcr:lastModified")).thenReturn((Object)this.mockProp);
        Mockito.when((Object)this.mockProp.getDate()).thenReturn((Object)Calendar.getInstance());
        this.testContainer.getLastModifiedDate();
        ((Node)Mockito.verify((Object)this.mockObjNode)).getProperty("jcr:lastModified");
    }

    @Test
    public void testHasType() {
        Assert.assertTrue((boolean)this.testContainer.hasType("some:type"));
    }
}

