/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import java.util.Set;
import javax.jcr.NamespaceRegistry;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.impl.observer.GetNamespacedProperties;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class GetNamespacedPropertiesTest {
    private GetNamespacedProperties function;
    @Mock
    private Session session;
    @Mock
    private NamespaceRegistry namespaceRegistry;
    @Mock
    private Event event;

    @Before
    public void setUp() throws Exception {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.event.getType()).thenReturn((Object)64);
        Workspace workspace = (Workspace)Mockito.mock(Workspace.class);
        Mockito.when((Object)this.session.getWorkspace()).thenReturn((Object)workspace);
        Mockito.when((Object)workspace.getNamespaceRegistry()).thenReturn((Object)this.namespaceRegistry);
        Mockito.when((Object)this.namespaceRegistry.getURI("fedora")).thenReturn((Object)"http://fedora.info/definitions/v4/repository#");
        Mockito.when((Object)this.namespaceRegistry.getURI("ldp")).thenReturn((Object)"http://www.w3.org/ns/ldp#");
        Mockito.when((Object)this.namespaceRegistry.getURI("jcr")).thenReturn((Object)"http://www.jcp.org/jcr/1.0");
        this.function = new GetNamespacedProperties(this.session);
    }

    @Test
    public void testApply() {
        FedoraEvent fedoraEvent = new FedoraEvent(this.event);
        fedoraEvent.addProperty("fedora:Container");
        fedoraEvent.addProperty("fedora:Tombstone");
        fedoraEvent.addProperty("ldp:BasicContainer");
        fedoraEvent.addProperty("jcr:mixinTypes");
        fedoraEvent.addType(Integer.valueOf(4));
        fedoraEvent.addType(Integer.valueOf(1));
        FedoraEvent result = this.function.apply(fedoraEvent);
        Assert.assertNotNull((Object)result);
        Set types = result.getTypes();
        Assert.assertEquals((long)3L, (long)types.size());
        Assert.assertTrue((String)("Should contain: 4, " + types), (boolean)types.contains(4));
        Assert.assertTrue((String)("Should contain: 1, " + types), (boolean)types.contains(1));
        Assert.assertTrue((String)("Should contain: 64, " + types), (boolean)types.contains(64));
        Set properties = result.getProperties();
        Assert.assertEquals((long)4L, (long)properties.size());
        String expected1 = "fedora:Container".replace("fedora:", "http://fedora.info/definitions/v4/repository#");
        String expected2 = "fedora:Tombstone".replace("fedora:", "http://fedora.info/definitions/v4/repository#");
        String expected3 = "ldp:BasicContainer".replace("ldp:", "http://www.w3.org/ns/ldp#");
        String expected4 = "jcr:mixinTypes".replace("jcr:", "http://fedora.info/definitions/v4/repository#");
        Assert.assertTrue((String)("Should contain: " + expected1 + ", " + properties), (boolean)properties.contains(expected1));
        Assert.assertTrue((String)("Should contain: " + expected2 + ", " + properties), (boolean)properties.contains(expected2));
        Assert.assertTrue((String)("Should contain: " + expected3 + ", " + properties), (boolean)properties.contains(expected3));
        Assert.assertTrue((String)("Should contain: " + expected4 + ", " + properties), (boolean)properties.contains(expected4));
    }
}

