/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import java.util.HashSet;
import javax.jcr.Session;
import javax.jcr.nodetype.NodeType;
import org.fcrepo.kernel.impl.observer.DefaultFilter;
import org.fcrepo.kernel.impl.observer.SuppressByMixinFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.modeshape.jcr.api.observation.Event;

public class SuppressByMixinFilterTest {
    private DefaultFilter testObj;
    @Mock
    private Session mockSession;
    @Mock
    private Event mockEvent;
    @Mock
    private NodeType fedoraContainer;
    @Mock
    private NodeType internalEvent;

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        HashSet<String> suppressedMixins = new HashSet<String>();
        suppressedMixins.add("audit:InternalEvent");
        this.testObj = new SuppressByMixinFilter(suppressedMixins);
        Mockito.when((Object)this.fedoraContainer.toString()).thenReturn((Object)"fedora:Container");
        Mockito.when((Object)this.internalEvent.toString()).thenReturn((Object)"audit:InternalEvent");
    }

    @Test
    public void shouldSuppressMixin() throws Exception {
        Mockito.when((Object)this.mockEvent.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.fedoraContainer, this.internalEvent});
        Assert.assertFalse((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }

    @Test
    public void shouldAllowOthers() throws Exception {
        Mockito.when((Object)this.mockEvent.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.fedoraContainer});
        Assert.assertTrue((boolean)this.testObj.getFilter(this.mockSession).apply((Object)this.mockEvent));
    }
}

