/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer.eventmappings;

import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.observer.eventmappings.AllNodeEventsOneEvent;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.jgroups.util.UUID;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AllNodeEventsOneEventTest {
    private static final String TEST_IDENTIFIER1;
    private static final String TEST_PATH1 = "/test/node1";
    private static final String TEST_IDENTIFIER2;
    private static final String TEST_PATH2 = "/test/node1/dc:title";
    private static final String TEST_IDENTIFIER3;
    private static final String TEST_PATH3 = "/test/node2";
    private static final String TEST_IDENTIFIER4;
    private static final String TEST_PATH4 = "/test/node3";
    private static final String TEST_IDENTIFIER5;
    private static final String TEST_PATH5 = "/test/node3/jcr:content";
    private final AllNodeEventsOneEvent testMapping = new AllNodeEventsOneEvent();
    @Mock
    private Event mockEvent1;
    @Mock
    private Event mockEvent2;
    @Mock
    private Event mockEvent3;
    @Mock
    private Event mockEvent4;
    @Mock
    private Event mockEvent5;
    @Mock
    private Iterator<Event> mockIterator;
    @Mock
    private Iterator<Event> mockIterator2;
    @Mock
    private Iterator<Event> mockIterator3;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockEvent1.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER1);
        Mockito.when((Object)this.mockEvent1.getPath()).thenReturn((Object)TEST_PATH1);
        Mockito.when((Object)this.mockEvent1.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockEvent2.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER2);
        Mockito.when((Object)this.mockEvent2.getPath()).thenReturn((Object)TEST_PATH2);
        Mockito.when((Object)this.mockEvent2.getType()).thenReturn((Object)4);
        Mockito.when((Object)this.mockEvent3.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER3);
        Mockito.when((Object)this.mockEvent3.getPath()).thenReturn((Object)TEST_PATH3);
        Mockito.when((Object)this.mockEvent3.getType()).thenReturn((Object)16);
        Mockito.when((Object)this.mockIterator.next()).thenReturn((Object)this.mockEvent1, (Object[])new Event[]{this.mockEvent2, this.mockEvent3});
        Mockito.when((Object)this.mockIterator.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, true, false});
        Mockito.when((Object)this.mockEvent4.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER4);
        Mockito.when((Object)this.mockEvent4.getPath()).thenReturn((Object)TEST_PATH4);
        Mockito.when((Object)this.mockEvent4.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockEvent5.getIdentifier()).thenReturn((Object)TEST_IDENTIFIER5);
        Mockito.when((Object)this.mockEvent5.getPath()).thenReturn((Object)TEST_PATH5);
        Mockito.when((Object)this.mockEvent5.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockIterator2.next()).thenReturn((Object)this.mockEvent4, (Object[])new Event[]{this.mockEvent5});
        Mockito.when((Object)this.mockIterator2.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)this.mockIterator3.next()).thenReturn((Object)this.mockEvent4, (Object[])new Event[]{this.mockEvent5});
        Mockito.when((Object)this.mockIterator3.hasNext()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
    }

    @Test
    public void testCardinality() {
        Assert.assertEquals((String)"Didn't get 2 FedoraEvents for 3 input JCR Events, two of which were on the same node!", (long)2L, (long)Iterators.size((Iterator)this.testMapping.apply(this.mockIterator)));
    }

    @Test
    public void testCollapseContentEvents() {
        Assert.assertEquals((String)"Didn't collapse content node and fcr:content events!", (long)1L, (long)Iterators.size((Iterator)this.testMapping.apply(this.mockIterator2)));
    }

    @Test
    public void testFileEventProperties() {
        FedoraEvent e = (FedoraEvent)this.testMapping.apply(this.mockIterator3).next();
        Assert.assertTrue((String)("Didn't add fedora:hasContent property to fcr:content events!: " + e.getProperties()), (boolean)e.getProperties().contains("fedora:hasContent"));
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testBadOPeration() {
        this.testMapping.apply(this.mockIterator).remove();
    }

    @Test(expected=RuntimeException.class)
    public void testBadEvent() throws RepositoryException {
        Mockito.reset((Object[])new Event[]{this.mockEvent1});
        Mockito.when((Object)this.mockEvent1.getIdentifier()).thenThrow(new Throwable[]{new RepositoryException("Expected.")});
        this.testMapping.apply(this.mockIterator);
    }

    @Test
    public void testPropertyEvents() throws RepositoryException {
        Iterator iterator = this.testMapping.apply(this.mockIterator);
        Assert.assertNotNull((Object)iterator);
        Assert.assertTrue((String)"Iterator is empty!", (boolean)iterator.hasNext());
        boolean found = false;
        while (iterator.hasNext()) {
            FedoraEvent event = (FedoraEvent)iterator.next();
            if (!TEST_IDENTIFIER3.equals(event.getIdentifier())) continue;
            Assert.assertEquals((String)"Expected one event property", (long)1L, (long)event.getProperties().size());
            found = true;
        }
        Assert.assertTrue((String)"Third mock event was not found!", (boolean)found);
    }

    @Test(expected=RepositoryRuntimeException.class)
    public void testError() throws RepositoryException {
        Mockito.when((Object)this.mockEvent3.getPath()).thenThrow(new Throwable[]{new RepositoryException("expected")});
        Iterator iterator = this.testMapping.apply(this.mockIterator);
        Assert.assertNotNull((Object)iterator);
        Iterators.getLast((Iterator)iterator);
    }

    static {
        TEST_IDENTIFIER2 = TEST_IDENTIFIER1 = UUID.randomUUID().toString();
        TEST_IDENTIFIER3 = UUID.randomUUID().toString();
        TEST_IDENTIFIER4 = UUID.randomUUID().toString();
        TEST_IDENTIFIER5 = UUID.randomUUID().toString();
    }
}

