/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.google.common.base.Function;
import com.hp.hpl.jena.rdf.model.Literal;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeDefinition;
import javax.jcr.nodetype.NodeType;
import javax.jcr.nodetype.NodeTypeIterator;
import javax.jcr.nodetype.NodeTypeManager;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.query.Query;
import javax.jcr.query.QueryManager;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import javax.jcr.version.Version;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.FedoraJcrTypes;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.CacheEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.modeshape.jcr.api.JcrTools;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.value.BinaryValue;

public class JcrRdfToolsTest
implements FedoraJcrTypes {
    private DefaultIdentifierTranslator testSubjects;
    private JcrRdfTools testObj;
    @Mock
    private com.hp.hpl.jena.rdf.model.Property mockPredicate;
    @Mock
    private Function<Property, com.hp.hpl.jena.rdf.model.Property> mockPredicateFactoryFunc;
    @Mock
    private NodeIterator mockNodes;
    @Mock
    private NodeIterator mockNodes2;
    @Mock
    private NodeIterator mockNodes3;
    @Mock
    private Function<Node, ValueFactory> mockValueFactoryFunc;
    @Mock
    private Node mockNode;
    @Mock
    private Node mockNode1;
    @Mock
    private Node mockNode2;
    @Mock
    private Node mockNode3;
    @Mock
    private Node mockParent;
    @Mock
    private Resource mockSubject;
    @Mock
    private Resource mockResource;
    @Mock
    private Session mockSession;
    @Mock
    private NodeType mockNodeType;
    @Mock
    private Property mockProperty;
    @Mock
    private PropertyDefinition mockPropertyDefinition;
    @Mock
    private Value mockValue;
    @Mock
    private Value mockReferenceValue;
    @Mock
    private Repository mockRepository;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private PropertyIterator mockProperties;
    @Mock
    private PropertyIterator mockProperties2;
    @Mock
    private PropertyIterator mockParentProperties;
    @Mock
    private Node mockContentNode;
    @Mock
    private Version mockVersion;
    @Mock
    private Node mockFrozenNode;
    @Mock
    private VersionManager mockVersionManager;
    @Mock
    private VersionIterator mockVersionIterator;
    @Mock
    private VersionHistory mockVersionHistory;
    @Mock
    private BinaryValue mockBinary;
    @Mock
    private CacheEntry mockCacheEntry;
    @Mock
    private QueryManager mockQueryManager;
    @Mock
    private Query mockQuery;
    @Mock
    private ValueFactory mockValueFactory;
    @Mock
    private QueryResult mockQueryResult;
    @Mock
    private RowIterator mockRowIterator;
    @Mock
    private MetricRegistry mockMetrics;
    @Mock
    private Node mockChildNode;
    @Mock
    private Node mockChildNode2;
    @Mock
    private Node mockChildNode3;
    @Mock
    private Node mockChildNode4;
    @Mock
    private Node mockChildNode5;
    @Mock
    private Node mockFullChildNode;
    @Mock
    private Node mockRootNode;
    @Mock
    private Node mockHashNode;
    @Mock
    private Counter mockCounter;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private NodeTypeIterator mockNodeTypeIterator;
    @Mock
    private NodeType mockMixinNodeType;
    @Mock
    private NodeType mockPrimaryNodeType;
    @Mock
    private NamespaceRegistry mockNsRegistry;
    @Mock
    private FedoraResource mockFedoraResource;

    @Before
    public final void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.testSubjects = new DefaultIdentifierTranslator(this.mockSession);
        this.buildMockNodeAndSurroundings();
        this.testObj = new JcrRdfTools((IdentifierConverter)this.testSubjects, this.mockSession);
    }

    private void buildMockNodeAndSurroundings() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getRepository()).thenReturn((Object)this.mockRepository);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNamespaceRegistry()).thenReturn((Object)this.mockNsRegistry);
        Mockito.when((Object)this.mockNsRegistry.isRegisteredUri("some:")).thenReturn((Object)true);
        Mockito.when((Object)this.mockNsRegistry.getPrefix("some:")).thenReturn((Object)"some");
        Mockito.when((Object)this.mockSession.getRootNode()).thenReturn((Object)this.mockRootNode);
        Mockito.when((Object)this.mockParent.getPath()).thenReturn((Object)"/test");
        Mockito.when((Object)this.mockParent.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/test/jcr");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockParent);
        Mockito.when((Object)this.mockNode.getNodes()).thenReturn((Object)this.mockNodes);
        Mockito.when((Object)this.mockNodes.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodes.next()).thenThrow(new Throwable[]{new NoSuchElementException()});
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockNodeType.getName()).thenReturn((Object)"jcr:someType");
        Mockito.when((Object)this.mockNodeType.getChildNodeDefinitions()).thenReturn((Object)new NodeDefinition[]{(NodeDefinition)Mockito.mock(NodeDefinition.class)});
        Mockito.when((Object)this.mockNode.getProperties()).thenReturn((Object)new TestPropertyIterator(this.mockProperty), (Object[])new PropertyIterator[]{new TestPropertyIterator(this.mockProperty), new TestPropertyIterator(this.mockProperty)});
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)"some:property");
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.isNodeType("nt:frozenNode")).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getDefinition()).thenReturn((Object)this.mockPropertyDefinition);
        Mockito.when((Object)this.mockPropertyDefinition.isProtected()).thenReturn((Object)false);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"abc");
        Mockito.when((Object)this.mockParent.getProperties()).thenReturn((Object)this.mockParentProperties);
        Mockito.when((Object)this.mockParentProperties.hasNext()).thenReturn((Object)false);
        Mockito.when((Object)this.mockNodeType.getSupertypes()).thenReturn((Object)new NodeType[]{this.mockNodeType});
        Mockito.when((Object)this.mockSession.getValueFactory()).thenReturn((Object)this.mockValueFactory);
        Mockito.when((Object)this.mockHashNode.getName()).thenReturn((Object)"#");
        Mockito.when((Object)this.mockFedoraResource.getNode()).thenReturn((Object)this.mockNode);
    }

    @Test
    public final void shouldMapReferenceValuesToJcrPropertyValues() throws RepositoryException {
        Resource n = this.testSubjects.toDomain("/abc");
        Mockito.when((Object)this.mockSession.getNode("/abc")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockSession.nodeExists("/abc")).thenReturn((Object)true);
        this.testObj.createValue(this.mockValueFactory, (RDFNode)n, 9);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(this.mockNode, false);
        this.testObj.createValue(this.mockValueFactory, (RDFNode)n, 10);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue(this.mockNode, true);
    }

    @Test
    public final void shouldMapValuesIntoExistingIntoJcrPropertyTypes() throws RepositoryException {
        Literal n = ResourceFactory.createTypedLiteral((Object)0);
        this.testObj.createValue(this.mockValueFactory, (RDFNode)n, 3);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("0", 3);
        Resource resource = ResourceFactory.createResource((String)"info:xyz");
        this.testObj.createValue(this.mockValueFactory, (RDFNode)resource, 11);
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("info:xyz", 11);
    }

    @Test(expected=ValueFormatException.class)
    public final void shouldMapRdfValuesToJcrPropertyValuesError() throws RepositoryException {
        Resource n = ResourceFactory.createResource();
        this.testObj.createValue(this.mockValueFactory, (RDFNode)n, 9);
    }

    @Test
    public void shouldAddReferencePropertyForDomainObject() throws RepositoryException {
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[0]);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockValueFactory.createValue(Matchers.anyString(), Matchers.eq((int)1))).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValueFactory.createValue(this.mockNode, true)).thenReturn((Object)this.mockReferenceValue);
        Mockito.when((Object)this.mockSession.getNode("/x")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.setProperty(Matchers.anyString(), (Value[])Matchers.any(Value[].class), Matchers.anyInt())).thenReturn((Object)this.mockProperty);
        this.testObj.addProperty(this.mockFedoraResource, ResourceFactory.createProperty((String)"some:property"), (RDFNode)this.testSubjects.toDomain("x"), Collections.emptyMap());
        ((Node)Mockito.verify((Object)this.mockNode)).setProperty("some:property_ref", new Value[]{this.mockReferenceValue}, this.mockReferenceValue.getType());
    }

    @Test
    public void shouldNotAddReferencePropertyForNonDomainObject() throws RepositoryException {
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[0]);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockValueFactory.createValue(Matchers.anyString(), Matchers.eq((int)1))).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValueFactory.createValue(this.mockNode, true)).thenReturn((Object)this.mockReferenceValue);
        Mockito.when((Object)this.mockSession.getNode("/x")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.setProperty(Matchers.anyString(), (Value[])Matchers.any(Value[].class), Matchers.anyInt())).thenReturn((Object)this.mockProperty);
        this.testObj.addProperty(this.mockFedoraResource, ResourceFactory.createProperty((String)"some:property"), (RDFNode)ResourceFactory.createResource((String)"some:resource"), Collections.emptyMap());
        ((Node)Mockito.verify((Object)this.mockNode, (VerificationMode)Mockito.never())).setProperty((String)Matchers.eq((Object)"some:property_ref"), (Value[])Matchers.any(Value[].class), Matchers.anyInt());
    }

    @Test
    public void testCreateValueForNode() throws RepositoryException {
        Mockito.when((Object)this.mockNode.getSession().getValueFactory()).thenReturn((Object)this.mockValueFactory);
        Mockito.when((Object)this.mockNode.getPrimaryNodeType()).thenReturn((Object)this.mockNodeType);
        Mockito.when((Object)this.mockNodeType.getPropertyDefinitions()).thenReturn((Object)new PropertyDefinition[0]);
        Mockito.when((Object)this.mockNode.getMixinNodeTypes()).thenReturn((Object)new NodeType[0]);
        Mockito.when((Object)this.mockValueFactory.createValue(Matchers.anyString(), Matchers.eq((int)1))).thenReturn((Object)this.mockValue);
        Literal n = ResourceFactory.createPlainLiteral((String)"x");
        this.testObj.createValue(this.mockNode, (RDFNode)n, "some:property");
        ((ValueFactory)Mockito.verify((Object)this.mockValueFactory)).createValue("x", 1);
    }

    @Test
    public final void shouldMapInternalJcrNamespaceToFcrepoNamespace() {
        Assert.assertEquals((Object)"http://fedora.info/definitions/v4/repository#", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"http://www.jcp.org/jcr/1.0"));
    }

    @Test
    public final void shouldMapFcrepoNamespaceToJcrNamespace() {
        Assert.assertEquals((Object)"http://www.jcp.org/jcr/1.0", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"http://fedora.info/definitions/v4/repository#"));
    }

    @Test
    public final void shouldPassThroughOtherNamespaceValues() {
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getJcrNamespaceForRDFNamespace((String)"some-namespace-uri"));
        Assert.assertEquals((Object)"some-namespace-uri", (Object)JcrRdfTools.getRDFNamespaceForJcrNamespace((String)"some-namespace-uri"));
    }

    @Test
    public void shouldPassthroughValidStatements() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(this.testSubjects.toDomain("/"), ResourceFactory.createProperty((String)"info:x"), (RDFNode)ResourceFactory.createPlainLiteral((String)"x"));
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)x, (Object)statement);
    }

    @Test
    public void shouldSkolemizeBlankNodeSubjects() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(ResourceFactory.createResource(), ResourceFactory.createProperty((String)"info:x"), (RDFNode)this.testSubjects.toDomain("/"));
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode((Session)Matchers.eq((Object)this.mockSession), Matchers.anyString())).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/.well-known/x");
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)"info:fedora/.well-known/x", (Object)statement.getSubject().toString());
    }

    @Test
    public void shouldSkolemizeBlankNodeObjects() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(this.testSubjects.toDomain("/"), ResourceFactory.createProperty((String)"info:x"), (RDFNode)ResourceFactory.createResource());
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode((Session)Matchers.eq((Object)this.mockSession), Matchers.anyString())).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/.well-known/x");
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)"info:fedora/.well-known/x", (Object)statement.getObject().toString());
    }

    @Test
    public void shouldSkolemizeBlankNodeSubjectsAndObjects() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Resource resource = ResourceFactory.createResource();
        Statement x = m.createStatement(resource, ResourceFactory.createProperty((String)"info:x"), (RDFNode)resource);
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode((Session)Matchers.eq((Object)this.mockSession), Matchers.anyString())).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/.well-known/x");
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)"info:fedora/.well-known/x", (Object)statement.getSubject().toString());
        Assert.assertEquals((Object)"info:fedora/.well-known/x", (Object)statement.getObject().toString());
    }

    @Test
    public void shouldCreateHashUriSubjects() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(this.testSubjects.toDomain("/some/#/abc"), ResourceFactory.createProperty((String)"info:x"), (RDFNode)this.testSubjects.toDomain("/"));
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockHashNode);
        Mockito.when((Object)this.mockHashNode.getParent()).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockSession.nodeExists("/some")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/some")).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockChildNode.isNew()).thenReturn((Object)false);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode(this.mockSession, "/some/#/abc", "nt:folder")).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockHashNode.isNew()).thenReturn((Object)true);
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)x, (Object)statement);
        ((JcrTools)Mockito.verify((Object)this.testObj.jcrTools)).findOrCreateNode(this.mockSession, "/some/#/abc", "nt:folder");
        ((Node)Mockito.verify((Object)this.mockNode)).addMixin("fedora:Resource");
        ((Node)Mockito.verify((Object)this.mockHashNode)).addMixin("fedora:Pairtree");
    }

    @Test
    public void shouldAddBlankNodePairtreeMixin() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Resource resource = ResourceFactory.createResource();
        Statement x = m.createStatement(resource, ResourceFactory.createProperty((String)"info:x"), (RDFNode)resource);
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode((Session)Matchers.eq((Object)this.mockSession), Matchers.anyString())).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)"/x");
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockHashNode);
        Mockito.when((Object)this.mockHashNode.getParent()).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockHashNode.isNew()).thenReturn((Object)true);
        Mockito.when((Object)FedoraTypesUtils.getClosestExistingAncestor((Session)this.mockSession, (String)"/.well-known/genid/")).thenReturn((Object)this.mockChildNode);
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)"info:fedora/x", (Object)statement.getSubject().toString());
        Assert.assertEquals((Object)"info:fedora/x", (Object)statement.getObject().toString());
        ((JcrTools)Mockito.verify((Object)this.testObj.jcrTools)).findOrCreateNode(this.mockSession, "/.well-known/genid/");
        ((Node)Mockito.verify((Object)this.mockNode)).addMixin("fedora:Blanknode");
        ((Node)Mockito.verify((Object)this.mockNode.getParent())).addMixin("fedora:Pairtree");
    }

    @Test
    public void shouldCreateHashUriSubjectsWithExistingHashUri() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(this.testSubjects.toDomain("/some/#/abc"), ResourceFactory.createProperty((String)"info:x"), (RDFNode)this.testSubjects.toDomain("/"));
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockHashNode);
        Mockito.when((Object)this.mockHashNode.getParent()).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockSession.nodeExists("/some")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/some")).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockChildNode.isNew()).thenReturn((Object)false);
        Mockito.when((Object)this.mockChildNode.hasNode("#")).thenReturn((Object)true);
        Mockito.when((Object)this.mockChildNode.getNode("#")).thenReturn((Object)this.mockHashNode);
        Mockito.when((Object)this.mockHashNode.isNew()).thenReturn((Object)false);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode(this.mockSession, "/some/#/abc", "nt:folder")).thenReturn((Object)this.mockNode);
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)x, (Object)statement);
        ((JcrTools)Mockito.verify((Object)this.testObj.jcrTools)).findOrCreateNode(this.mockSession, "/some/#/abc", "nt:folder");
        ((Node)Mockito.verify((Object)this.mockNode)).addMixin("fedora:Resource");
    }

    @Test(expected=PathNotFoundException.class)
    public void shouldNotAllowHashUriSubjectsForResourcesThatDontExist() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(this.testSubjects.toDomain("/some/#/abc"), ResourceFactory.createProperty((String)"info:x"), (RDFNode)this.testSubjects.toDomain("/"));
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockHashNode);
        Mockito.when((Object)this.mockHashNode.getParent()).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockSession.nodeExists("/some")).thenReturn((Object)false);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode(this.mockSession, "/some/#/abc", "nt:folder")).thenReturn((Object)this.mockNode);
        this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
    }

    @Test
    public void shouldCreateHashUriObjects() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(this.testSubjects.toDomain("/"), ResourceFactory.createProperty((String)"info:x"), (RDFNode)this.testSubjects.toDomain("/some/#/abc"));
        this.testObj.jcrTools = (JcrTools)Mockito.mock(JcrTools.class);
        Mockito.when((Object)this.mockNode.getParent()).thenReturn((Object)this.mockHashNode);
        Mockito.when((Object)this.mockHashNode.getParent()).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.mockSession.nodeExists("/some")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNode("/some")).thenReturn((Object)this.mockChildNode);
        Mockito.when((Object)this.testObj.jcrTools.findOrCreateNode(this.mockSession, "/some/#/abc", "nt:folder")).thenReturn((Object)this.mockNode);
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)x, (Object)statement);
        ((JcrTools)Mockito.verify((Object)this.testObj.jcrTools)).findOrCreateNode(this.mockSession, "/some/#/abc", "nt:folder");
        ((Node)Mockito.verify((Object)this.mockNode)).addMixin("fedora:Resource");
    }

    @Test
    public void shouldIgnoreHashUrisOutsideTheRepositoryDomain() throws RepositoryException {
        Model m = ModelFactory.createDefaultModel();
        Statement x = m.createStatement(this.testSubjects.toDomain("/"), ResourceFactory.createProperty((String)"info:x"), (RDFNode)ResourceFactory.createResource((String)"info:x#abc"));
        Statement statement = this.testObj.skolemize((IdentifierConverter)this.testSubjects, x);
        Assert.assertEquals((Object)x, (Object)statement);
    }
}

