/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Arrays;
import javax.jcr.Session;
import org.fcrepo.kernel.impl.rdf.impl.PrefixingIdentifierTranslator;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;

@RunWith(value=Parameterized.class)
public class PrefixingIdentifierTranslatorTest {
    @Parameterized.Parameter(value=0)
    public String internalId;
    @Parameterized.Parameter(value=1)
    public String externalId;
    private PrefixingIdentifierTranslator testObj;
    @Mock
    private Session mockSession;

    @Parameterized.Parameters
    public static Iterable<String[]> data() {
        return Arrays.asList({"/", "http://example.com:8080/rest/"}, {"/some/path", "http://example.com:8080/rest/some/path"}, {"/some/path/#/with-a-hash-uri", "http://example.com:8080/rest/some/path#with-a-hash-uri"});
    }

    @Before
    public void setUp() {
        MockitoAnnotations.initMocks((Object)this);
        this.testObj = new PrefixingIdentifierTranslator(this.mockSession, "http://example.com:8080/rest/");
    }

    @Test
    public void testToString() {
        Assert.assertEquals((Object)this.internalId, (Object)this.testObj.asString(ResourceFactory.createResource((String)this.externalId)));
    }

    @Test
    public void testToDomain() {
        Assert.assertEquals((Object)ResourceFactory.createResource((String)this.externalId), (Object)this.testObj.toDomain(this.internalId));
    }
}

