/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.rdf.model.Statement;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.nodetype.PropertyDefinition;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.impl.testutilities.TestPropertyIterator;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class PropertiesRdfContextTest {
    @Mock
    private FedoraResource mockResource;
    @Mock
    private FedoraBinary mockBinary;
    @Mock
    private Node mockResourceNode;
    @Mock
    private Node mockBinaryNode;
    @Mock
    private NonRdfSourceDescription mockNonRdfSourceDescription;
    @Mock
    private Session mockSession;
    private IdentifierConverter<Resource, FedoraResource> idTranslator;
    private static final String RDF_PROPERTY_NAME = "rdf-property-name";
    private static final String RDF_PROPERTY_VALUE = "test:rdf-value";
    private static final String BINARY_PROPERTY_NAME = "binary-property-name";
    private static final String BINARY_PROPERTY_VALUE = "test:binary-value";
    private static final String RDF_PATH = "/resource/path";
    private static final String BINARY_PATH = "/binary/path";
    private static final Statement RDF_SOURCE_STMT = ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)"info:fedora/resource/path"), (com.hp.hpl.jena.rdf.model.Property)ResourceFactory.createProperty((String)"rdf-property-name"), (RDFNode)ResourceFactory.createResource((String)"test:rdf-value"));
    private static final Statement NON_RDF_SOURCE_STMT = ResourceFactory.createStatement((Resource)ResourceFactory.createResource((String)"info:fedora/binary/path"), (com.hp.hpl.jena.rdf.model.Property)ResourceFactory.createProperty((String)"binary-property-name"), (RDFNode)ResourceFactory.createResource((String)"test:binary-value"));

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        Mockito.when((Object)this.mockResource.getNode()).thenReturn((Object)this.mockResourceNode);
        Mockito.when((Object)this.mockResourceNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockResource.getPath()).thenReturn((Object)RDF_PATH);
        Property mockResourceProperty = (Property)Mockito.mock(Property.class);
        PropertyDefinition mockPropertyDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)mockPropertyDefinition.isProtected()).thenReturn((Object)false);
        Mockito.when((Object)mockResourceProperty.getDefinition()).thenReturn((Object)mockPropertyDefinition);
        Mockito.when((Object)mockResourceProperty.getParent()).thenReturn((Object)this.mockResourceNode);
        Value mockResourcePropertyValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)mockResourcePropertyValue.getType()).thenReturn((Object)11);
        Mockito.when((Object)mockResourceProperty.getValue()).thenReturn((Object)mockResourcePropertyValue);
        Mockito.when((Object)mockResourceProperty.getName()).thenReturn((Object)RDF_PROPERTY_NAME);
        Mockito.when((Object)mockResourcePropertyValue.getString()).thenReturn((Object)RDF_PROPERTY_VALUE);
        Mockito.when((Object)this.mockResourceNode.getProperties()).thenReturn((Object)new TestPropertyIterator(mockResourceProperty));
        Mockito.when((Object)this.mockResourceNode.getPath()).thenReturn((Object)RDF_PATH);
        Mockito.when((Object)this.mockBinary.getNode()).thenReturn((Object)this.mockBinaryNode);
        Mockito.when((Object)this.mockBinaryNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockBinary.getPath()).thenReturn((Object)BINARY_PATH);
        Mockito.when((Object)this.mockBinary.getDescription()).thenReturn((Object)this.mockNonRdfSourceDescription);
        Mockito.when((Object)this.mockNonRdfSourceDescription.getNode()).thenReturn((Object)this.mockResourceNode);
        Property mockNonRdfProperty = (Property)Mockito.mock(Property.class);
        PropertyDefinition mockNonRdfPropertyDefinition = (PropertyDefinition)Mockito.mock(PropertyDefinition.class);
        Mockito.when((Object)mockNonRdfPropertyDefinition.isProtected()).thenReturn((Object)false);
        Mockito.when((Object)mockNonRdfProperty.getDefinition()).thenReturn((Object)mockNonRdfPropertyDefinition);
        Mockito.when((Object)mockNonRdfProperty.getParent()).thenReturn((Object)this.mockBinaryNode);
        Value mockNonRdfPropertyValue = (Value)Mockito.mock(Value.class);
        Mockito.when((Object)mockNonRdfPropertyValue.getType()).thenReturn((Object)11);
        Mockito.when((Object)mockNonRdfProperty.getValue()).thenReturn((Object)mockNonRdfPropertyValue);
        Mockito.when((Object)mockNonRdfProperty.getName()).thenReturn((Object)BINARY_PROPERTY_NAME);
        Mockito.when((Object)mockNonRdfPropertyValue.getString()).thenReturn((Object)BINARY_PROPERTY_VALUE);
        Mockito.when((Object)this.mockBinaryNode.getProperties()).thenReturn((Object)new TestPropertyIterator(mockNonRdfProperty));
        Mockito.when((Object)this.mockBinaryNode.getPath()).thenReturn((Object)BINARY_PATH);
        this.idTranslator = new DefaultIdentifierTranslator(this.mockSession);
    }

    @Test
    public void testFedoraBinaryProperties() throws RepositoryException {
        Model results = new PropertiesRdfContext((FedoraResource)this.mockBinary, this.idTranslator).asModel();
        Assert.assertTrue((String)("Should contain RdfSource statement: " + results + " -- " + RDF_SOURCE_STMT), (boolean)results.contains(RDF_SOURCE_STMT));
        Assert.assertTrue((String)("Should contain NonRdfSource statement: " + results + " -- " + NON_RDF_SOURCE_STMT), (boolean)results.contains(NON_RDF_SOURCE_STMT));
    }

    @Test
    public void testFedoraResourceProperties() throws RepositoryException {
        Model results = new PropertiesRdfContext(this.mockResource, this.idTranslator).asModel();
        Assert.assertTrue((String)("Should contain RdfSource statement: " + results + " -- " + RDF_SOURCE_STMT), (boolean)results.contains(RDF_SOURCE_STMT));
        Assert.assertFalse((String)("Should NOT contain NonRdfSource statement: " + results + " -- " + NON_RDF_SOURCE_STMT), (boolean)results.contains(NON_RDF_SOURCE_STMT));
    }
}

