/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl.mappings;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyToTriple;
import org.fcrepo.kernel.impl.utils.JcrPropertyMock;
import org.fcrepo.kernel.models.FedoraResource;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyToTripleTest {
    private Node testSubject;
    private PropertyToTriple testPropertyToTriple;
    @Mock
    private Session mockSession;
    private IdentifierConverter<Resource, FedoraResource> idTranslator;
    @Mock
    private JcrPropertyMock mockProperty;
    @Mock
    private Value mockValue;
    @Mock
    private Value mockValue2;
    @Mock
    private javax.jcr.Node mockNode;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyToTripleTest.class);
    private static final String TEST_NODE_PATH = "/test";
    private static final String TEST_VALUE = "test value";
    private static final String TEST_PROPERTY_NAME = "info:predicate";

    @Test
    public void testMultiValuedLiteralTriple() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)new Value[]{this.mockValue, this.mockValue2});
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)TEST_VALUE);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockValue2.getString()).thenReturn((Object)TEST_VALUE);
        Mockito.when((Object)this.mockValue2.getType()).thenReturn((Object)1);
        Iterator ts = this.testPropertyToTriple.apply((Property)this.mockProperty);
        Triple t1 = (Triple)ts.next();
        LOGGER.debug("Constructed triple: {}", (Object)t1);
        Triple t2 = (Triple)ts.next();
        LOGGER.debug("Constructed triple: {}", (Object)t2);
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)TEST_VALUE, (Object)t1.getObject().getLiteralValue());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t1.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t1.getSubject());
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)TEST_VALUE, (Object)t2.getObject().getLiteralValue());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t2.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t2.getSubject());
    }

    @Test
    public void testSingleValuedResourceTriple() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)8);
        Mockito.when((Object)this.mockProperty.getString()).thenReturn((Object)TEST_NODE_PATH);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)TEST_NODE_PATH);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)8);
        Iterator ts = this.testPropertyToTriple.apply((Property)this.mockProperty);
        Triple t = (Triple)ts.next();
        LOGGER.debug("Constructed triple: {}", (Object)t);
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)this.testSubject, (Object)t.getObject());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test
    public void testSingleValuedStringLiteralTriple() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)1);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)TEST_VALUE);
        Triple t = this.createSingleValuedLiteralTriple();
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)TEST_VALUE, (Object)t.getObject().getLiteralValue());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test
    public void testSingleValuedBooleanLiteralTriple() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)6);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)6);
        Mockito.when((Object)this.mockValue.getBoolean()).thenReturn((Object)true);
        Triple t = this.createSingleValuedLiteralTriple();
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)true, (Object)t.getObject().getLiteralValue());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test
    public void testSingleValuedDateLiteralTriple() throws RepositoryException {
        Calendar date = Calendar.getInstance();
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)5);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)5);
        Mockito.when((Object)this.mockValue.getDate()).thenReturn((Object)date);
        Triple t = this.createSingleValuedLiteralTriple();
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)ResourceFactory.createTypedLiteral((Object)date).asNode().getLiteral(), (Object)t.getObject().getLiteral());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test
    public void testSingleValuedDecimalLiteralTriple() throws RepositoryException {
        BigDecimal num = BigDecimal.valueOf(3.141);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)12);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)12);
        Mockito.when((Object)this.mockValue.getDecimal()).thenReturn((Object)num);
        Triple t = this.createSingleValuedLiteralTriple();
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)ResourceFactory.createTypedLiteral((Object)num).asNode().getLiteral(), (Object)t.getObject().getLiteral());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test
    public void testSingleValuedDoubleLiteralTriple() throws RepositoryException {
        Double num = 3.141;
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)4);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)4);
        Mockito.when((Object)this.mockValue.getDouble()).thenReturn((Object)num);
        Triple t = this.createSingleValuedLiteralTriple();
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)ResourceFactory.createTypedLiteral((Object)num).asNode().getLiteral(), (Object)t.getObject().getLiteral());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test
    public void testSingleValuedLongLiteralTriple() throws RepositoryException {
        Long num = 3L;
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)3);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)3);
        Mockito.when((Object)this.mockValue.getLong()).thenReturn((Object)num);
        Triple t = this.createSingleValuedLiteralTriple();
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)ResourceFactory.createTypedLiteral((Object)num).asNode().getLiteral(), (Object)t.getObject().getLiteral());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test
    public void testSingleValuedUriLiteralTriple() throws RepositoryException {
        String uri = "http://example.com/example-uri";
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)11);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)11);
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)"http://example.com/example-uri");
        Triple t = this.createSingleValuedLiteralTriple();
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)ResourceFactory.createResource((String)"http://example.com/example-uri").asNode(), (Object)t.getObject());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t.getSubject());
    }

    @Test(expected=RuntimeException.class)
    public void testBadSingleValuedTriple() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)11);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)11);
        Mockito.when((Object)this.mockValue.getString()).thenThrow(new Throwable[]{new RepositoryException("Bad value!")});
        this.createSingleValuedLiteralTriple();
    }

    @Test
    public void testMultiValuedResourceTriple() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)8);
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)new Value[]{this.mockValue, this.mockValue2});
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)TEST_NODE_PATH);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)8);
        Mockito.when((Object)this.mockValue2.getString()).thenReturn((Object)TEST_NODE_PATH);
        Mockito.when((Object)this.mockValue2.getType()).thenReturn((Object)8);
        Iterator ts = this.testPropertyToTriple.apply((Property)this.mockProperty);
        Triple t1 = (Triple)ts.next();
        LOGGER.debug("Constructed triple for testMultiValuedResourceTriple(): {}", (Object)t1);
        Triple t2 = (Triple)ts.next();
        LOGGER.debug("Constructed triple for testMultiValuedResourceTriple(): {}", (Object)t2);
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)this.testSubject, (Object)t1.getObject());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t1.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t1.getSubject());
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)this.testSubject, (Object)t2.getObject());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t2.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t2.getSubject());
    }

    @Test
    public void testMultiValuedResourceTripleWithReference() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)true);
        Mockito.when((Object)this.mockProperty.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockProperty.getValues()).thenReturn((Object)new Value[]{this.mockValue, this.mockValue2});
        Mockito.when((Object)this.mockValue.getString()).thenReturn((Object)TEST_NODE_PATH);
        Mockito.when((Object)this.mockValue.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockValue2.getString()).thenReturn((Object)TEST_NODE_PATH);
        Mockito.when((Object)this.mockValue2.getType()).thenReturn((Object)9);
        Mockito.when((Object)this.mockSession.getNodeByIdentifier(TEST_NODE_PATH)).thenReturn((Object)this.mockNode);
        Iterator ts = this.testPropertyToTriple.apply((Property)this.mockProperty);
        Triple t1 = (Triple)ts.next();
        LOGGER.debug("Constructed triple for testMultiValuedResourceTriple(): {}", (Object)t1);
        Triple t2 = (Triple)ts.next();
        LOGGER.debug("Constructed triple for testMultiValuedResourceTriple(): {}", (Object)t2);
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)this.testSubject, (Object)t1.getObject());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t1.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t1.getSubject());
        Assert.assertEquals((String)"Got wrong RDF object!", (Object)this.testSubject, (Object)t2.getObject());
        Assert.assertEquals((String)"Got wrong RDF predicate!", (Object)ResourceFactory.createProperty((String)TEST_PROPERTY_NAME).asNode(), (Object)t2.getPredicate());
        Assert.assertEquals((String)"Got wrong RDF subject!", (Object)this.testSubject, (Object)t2.getSubject());
    }

    @Test(expected=RepositoryException.class)
    public void badProperty() throws AccessDeniedException, ItemNotFoundException, RepositoryException {
        Mockito.when((Object)this.mockProperty.getParent()).thenThrow(new Throwable[]{new RepositoryException("Bad property!")});
        this.mockProperty.getParent();
        this.createSingleValuedLiteralTriple();
    }

    private Triple createSingleValuedLiteralTriple() throws RepositoryException {
        Mockito.when((Object)this.mockProperty.isMultiple()).thenReturn((Object)false);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Iterator ts = this.testPropertyToTriple.apply((Property)this.mockProperty);
        Triple t = (Triple)ts.next();
        LOGGER.debug("Constructed triple: {}", (Object)t);
        return t;
    }

    @Before
    public void setUp() throws ValueFormatException, RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.idTranslator = new DefaultIdentifierTranslator(this.mockSession);
        this.testPropertyToTriple = new PropertyToTriple(this.mockSession, this.idTranslator);
        Mockito.when((Object)this.mockProperty.getValue()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockProperty.getParent()).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockProperty.getName()).thenReturn((Object)TEST_PROPERTY_NAME);
        Mockito.when((Object)this.mockProperty.getNamespaceURI()).thenReturn((Object)"info:");
        Mockito.when((Object)this.mockProperty.getLocalName()).thenReturn((Object)"predicate");
        Mockito.when((Object)this.mockProperty.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getNode(TEST_NODE_PATH)).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getNode(TEST_NODE_PATH)).thenReturn((Object)this.mockNode);
        Mockito.when((Object)this.mockNode.getPath()).thenReturn((Object)TEST_NODE_PATH);
        this.testSubject = ((Resource)NodeResourceConverter.nodeToResource(this.idTranslator).convert((Object)this.mockNode)).asNode();
    }
}

