/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.nodetype.NodeTypeManager;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.impl.DefaultIdentifierTranslator;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.impl.utils.JcrPropertyStatementListener;
import org.fcrepo.kernel.impl.utils.NodePropertiesTools;
import org.fcrepo.kernel.models.FedoraResource;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Ignore
public class JcrPropertyStatementListenerTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(JcrPropertyStatementListenerTest.class);
    private JcrPropertyStatementListener testObj;
    @Mock
    private Node mockNode;
    @Mock
    private Session mockSession;
    private IdentifierConverter<Resource, FedoraResource> idTranslator;
    @Mock
    private Statement mockStatement;
    @Mock
    private Statement mockIrrelevantStatement;
    @Mock
    private Resource mockSubject;
    @Mock
    private Property mockPredicate;
    @Mock
    private Node mockSubjectNode;
    @Mock
    private JcrRdfTools mockJcrRdfTools;
    @Mock
    private Workspace mockWorkspace;
    @Mock
    private NodeTypeManager mockNodeTypeManager;
    @Mock
    private Model mockModel;
    private Map<String, String> mockNsMapping = Collections.emptyMap();
    @Mock
    private NodePropertiesTools mockPropertiesTools;
    @Mock
    private RDFNode mockValue;
    private Resource mockResource;
    private FedoraResource resource;

    @Before
    public void setUp() throws RepositoryException {
        MockitoAnnotations.initMocks((Object)this);
        this.idTranslator = new DefaultIdentifierTranslator(this.mockSession);
        Mockito.when((Object)this.mockNode.getSession()).thenReturn((Object)this.mockSession);
        this.testObj = new JcrPropertyStatementListener(this.idTranslator, this.mockJcrRdfTools);
        this.mockResource = (Resource)this.idTranslator.toDomain("/xyz");
        Mockito.when((Object)this.mockStatement.getSubject()).thenReturn((Object)this.mockResource);
        Mockito.when((Object)this.mockStatement.getPredicate()).thenReturn((Object)this.mockPredicate);
        Mockito.when((Object)this.mockStatement.getModel()).thenReturn((Object)this.mockModel);
        Mockito.when((Object)this.mockStatement.getObject()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockSession.getNode("/xyz")).thenReturn((Object)this.mockSubjectNode);
        Mockito.when((Object)this.mockSubjectNode.getPath()).thenReturn((Object)"/xyz");
        Mockito.when((Object)this.mockIrrelevantStatement.getSubject()).thenReturn((Object)this.mockSubject);
        Mockito.when((Object)this.mockIrrelevantStatement.getPredicate()).thenReturn((Object)this.mockPredicate);
        Mockito.when((Object)this.mockIrrelevantStatement.getModel()).thenReturn((Object)this.mockModel);
        Mockito.when((Object)this.mockIrrelevantStatement.getObject()).thenReturn((Object)this.mockValue);
        Mockito.when((Object)this.mockModel.getNsPrefixMap()).thenReturn(this.mockNsMapping);
        this.resource = (FedoraResource)this.idTranslator.convert((Object)this.mockResource);
        Mockito.when((Object)this.mockJcrRdfTools.skolemize(this.idTranslator, this.mockStatement)).thenReturn((Object)this.mockStatement);
    }

    @Test
    public void testAddedIrrelevantStatement() {
        this.testObj.addedStatement(this.mockIrrelevantStatement);
    }

    @Test
    public void testAddedStatement() throws RepositoryException {
        Mockito.when((Object)this.mockSession.getNode("/some/path")).thenReturn((Object)this.mockSubjectNode);
        this.testObj.addedStatement(this.mockStatement);
        ((JcrRdfTools)Mockito.verify((Object)this.mockJcrRdfTools)).addProperty(this.resource, this.mockStatement.getPredicate(), this.mockStatement.getObject(), this.mockNsMapping);
        LOGGER.debug("Finished testAddedStatement()");
    }

    @Test(expected=RuntimeException.class)
    public void testAddedStatementRepositoryException() throws RepositoryException {
        ((JcrRdfTools)Mockito.doThrow((Throwable)new RepositoryRuntimeException("")).when((Object)this.mockJcrRdfTools)).addProperty(this.resource, this.mockPredicate, this.mockValue, this.mockNsMapping);
        this.testObj.addedStatement(this.mockStatement);
    }

    @Test
    public void testRemovedStatement() throws RepositoryException {
        this.testObj.removedStatement(this.mockStatement);
        ((JcrRdfTools)Mockito.verify((Object)this.mockJcrRdfTools)).removeProperty(this.resource, this.mockStatement.getPredicate(), this.mockStatement.getObject(), this.mockNsMapping);
    }

    @Test(expected=RuntimeException.class)
    public void testRemovedStatementRepositoryException() throws RepositoryException {
        ((JcrRdfTools)Mockito.doThrow((Throwable)new RepositoryRuntimeException("")).when((Object)this.mockJcrRdfTools)).removeProperty(this.resource, this.mockPredicate, this.mockValue, this.mockNsMapping);
        this.testObj.removedStatement(this.mockStatement);
    }

    @Test
    public void testRemovedIrrelevantStatement() {
        this.testObj.removedStatement(this.mockIrrelevantStatement);
    }

    @Test
    public void testAddRdfType() throws RepositoryException {
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/repository#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        Resource type = model.createResource("http://fedora.info/definitions/v4/repository#object");
        Statement statement = model.createStatement(this.mockResource, RDF.type, (RDFNode)type);
        Mockito.when((Object)this.mockSubjectNode.canAddMixin("fedora:object")).thenReturn((Object)true);
        Mockito.when((Object)this.mockJcrRdfTools.skolemize(this.idTranslator, statement)).thenReturn((Object)statement);
        this.testObj.addedStatement(statement);
        ((JcrRdfTools)Mockito.verify((Object)this.mockJcrRdfTools)).addMixin(this.resource, type, this.mockNsMapping);
    }

    @Test
    public void testRemoveRdfType() throws RepositoryException {
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)true);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/repository#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        Resource type = model.createResource("http://fedora.info/definitions/v4/repository#Container");
        model.add(this.mockResource, RDF.type, (RDFNode)type);
        this.testObj.removedStatements(model);
        ((JcrRdfTools)Mockito.verify((Object)this.mockJcrRdfTools)).removeMixin(this.resource, type, this.mockNsMapping);
    }

    @Test
    public void testAddRdfTypeForNonMixin() throws RepositoryException {
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)false);
        Mockito.when((Object)FedoraTypesUtils.getPropertyType((Node)this.mockSubjectNode, (String)"rdf:type")).thenReturn((Object)11);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/repository#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        Statement statement = model.createStatement(this.mockResource, RDF.type, (RDFNode)model.createResource("http://fedora.info/definitions/v4/repository#Container"));
        Mockito.when((Object)this.mockSubjectNode.canAddMixin("fedora:object")).thenReturn((Object)true);
        Mockito.when((Object)this.mockJcrRdfTools.skolemize(this.idTranslator, statement)).thenReturn((Object)statement);
        this.testObj.addedStatement(statement);
        ((Node)Mockito.verify((Object)this.mockSubjectNode, (VerificationMode)Mockito.never())).addMixin("fedora:object");
    }

    @Test
    public void testRemoveRdfTypeForNonMixin() throws RepositoryException {
        Mockito.when((Object)this.mockSubjectNode.getSession()).thenReturn((Object)this.mockSession);
        Mockito.when((Object)this.mockSession.getWorkspace()).thenReturn((Object)this.mockWorkspace);
        Mockito.when((Object)this.mockWorkspace.getNodeTypeManager()).thenReturn((Object)this.mockNodeTypeManager);
        Mockito.when((Object)this.mockNodeTypeManager.hasNodeType("fedora:object")).thenReturn((Object)false);
        Mockito.when((Object)this.mockSession.getNamespacePrefix("http://fedora.info/definitions/v4/repository#")).thenReturn((Object)"fedora");
        Model model = ModelFactory.createDefaultModel();
        model.add(this.mockResource, RDF.type, (RDFNode)model.createResource("http://fedora.info/definitions/v4/repository#Container"));
        this.testObj.removedStatements(model);
        ((Node)Mockito.verify((Object)this.mockSubjectNode, (VerificationMode)Mockito.never())).removeMixin("fedora:Container");
    }
}

