/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Throwables;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.observer.EventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultFilter
implements EventFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultFilter.class);
    private static final HashSet<String> fedoraMixins = Sets.newHashSet((Object[])new String[]{"fedora:Binary", "fedora:Container", "fedora:NonRdfSourceDescription", "fedora:Resource"});

    public Predicate<Event> getFilter(Session session) {
        return new DefaultFilter();
    }

    public boolean apply(Event event) {
        try {
            return !Collections.disjoint(DefaultFilter.getMixinTypes(event), fedoraMixins);
        }
        catch (PathNotFoundException e) {
            LOGGER.trace("Dropping event from outside our assigned workspace:\n", (Throwable)e);
            return false;
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected static Collection<String> getMixinTypes(Event event) throws PathNotFoundException, RepositoryException {
        try {
            org.modeshape.jcr.api.observation.Event modeEvent = (org.modeshape.jcr.api.observation.Event)event;
            return Collections2.transform(Arrays.asList(modeEvent.getMixinNodeTypes()), (Function)Functions.toStringFunction());
        }
        catch (ClassCastException e) {
            throw new ClassCastException(event + " is not a Modeshape Event");
        }
    }
}

