/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import com.google.common.base.Function;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.impl.observer.SimpleObserver;
import org.fcrepo.kernel.observer.FedoraEvent;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetNamespacedProperties
implements Function<FedoraEvent, FedoraEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleObserver.class);
    private Session session;

    public GetNamespacedProperties(Session session) {
        this.session = session;
    }

    public FedoraEvent apply(FedoraEvent evt) {
        NamespaceRegistry namespaceRegistry = NamespaceTools.getNamespaceRegistry((Session)this.session);
        FedoraEvent event = new FedoraEvent(evt);
        for (String property : evt.getProperties()) {
            String[] parts = property.split(":", 2);
            if (parts.length == 2) {
                String prefix = parts[0];
                if ("jcr".equals(prefix)) {
                    if (RdfLexicon.jcrProperties.contains(ResourceFactory.createProperty((String)("http://fedora.info/definitions/v4/repository#" + parts[1])))) {
                        event.addProperty("http://fedora.info/definitions/v4/repository#" + parts[1]);
                        continue;
                    }
                    LOGGER.debug("Swallowing jcr property: {}", (Object)property);
                    continue;
                }
                try {
                    event.addProperty(namespaceRegistry.getURI(prefix) + parts[1]);
                }
                catch (RepositoryException ex) {
                    LOGGER.debug("Prefix could not be dereferenced using the namespace registry: {}", (Object)property);
                    event.addProperty(property);
                }
                continue;
            }
            event.addProperty(property);
        }
        for (Integer type : evt.getTypes()) {
            event.addType(type);
        }
        return event;
    }
}

