/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Set;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.observation.Event;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.observer.DefaultFilter;
import org.fcrepo.kernel.observer.EventFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuppressByMixinFilter
extends DefaultFilter
implements EventFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SuppressByMixinFilter.class);
    private Set<String> suppressedMixins;

    public SuppressByMixinFilter(Set<String> suppressedMixins) {
        this.suppressedMixins = suppressedMixins;
        for (String mixin : suppressedMixins) {
            LOGGER.info("Suppressing events for nodes with mixin: {}", (Object)mixin);
        }
    }

    @Override
    public Predicate<Event> getFilter(Session session) {
        return this;
    }

    @Override
    public boolean apply(Event event) {
        try {
            return super.apply(event) && Collections.disjoint(SuppressByMixinFilter.getMixinTypes(event), this.suppressedMixins);
        }
        catch (PathNotFoundException e) {
            LOGGER.trace("Dropping event from outside our assigned workspace:\n", (Throwable)e);
            return false;
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }
}

