/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.converters;

import com.google.common.base.Converter;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableBiMap;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import java.util.Map;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.exception.FedoraInvalidNamespaceException;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.utils.NamespaceTools;
import org.modeshape.jcr.api.NamespaceRegistry;
import org.modeshape.jcr.api.Namespaced;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyConverter
extends Converter<Property, com.hp.hpl.jena.rdf.model.Property> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyConverter.class);

    protected com.hp.hpl.jena.rdf.model.Property doForward(Property property) {
        LOGGER.trace("Creating predicate for property: {}", (Object)property);
        try {
            if (property instanceof Namespaced) {
                Namespaced nsProperty = (Namespaced)property;
                String uri = nsProperty.getNamespaceURI();
                String localName = nsProperty.getLocalName();
                String rdfLocalName = FedoraTypesUtils.isInternalReferenceProperty.apply((Object)property) ? FedoraTypesUtils.getReferencePropertyOriginalName(localName) : localName;
                return ResourceFactory.createProperty((String)JcrRdfTools.getRDFNamespaceForJcrNamespace(uri), (String)rdfLocalName);
            }
            return ResourceFactory.createProperty((String)property.getName());
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected Property doBackward(com.hp.hpl.jena.rdf.model.Property property) {
        throw new UnsupportedOperationException();
    }

    public static String getPropertyNameFromPredicate(Node node, Resource predicate, Map<String, String> namespaceMapping) throws RepositoryException {
        NamespaceRegistry namespaceRegistry = (NamespaceRegistry)NamespaceTools.getNamespaceRegistry.apply((Object)node);
        return PropertyConverter.getPropertyNameFromPredicate(namespaceRegistry, predicate, namespaceMapping);
    }

    public static String getPropertyNameFromPredicate(NamespaceRegistry namespaceRegistry, Resource predicate, Map<String, String> namespaceMapping) throws RepositoryException {
        String prefix;
        if (namespaceMapping != null && namespaceMapping.containsKey("fcr")) {
            throw new FedoraInvalidNamespaceException("Invalid fcr namespace properties " + predicate + ".");
        }
        String rdfNamespace = predicate.getNameSpace();
        if (namespaceMapping != null && !namespaceMapping.containsValue(rdfNamespace)) {
            LOGGER.warn("The namespace of predicate: {} was possibly misinterpreted as: {}.", (Object)predicate, (Object)rdfNamespace);
        }
        String rdfLocalname = predicate.getLocalName();
        assert (namespaceRegistry != null);
        String namespace = JcrRdfTools.getJcrNamespaceForRDFNamespace(rdfNamespace);
        if (namespaceRegistry.isRegisteredUri(namespace)) {
            LOGGER.debug("Discovered namespace: {} in namespace registry.", (Object)namespace);
            prefix = namespaceRegistry.getPrefix(namespace);
        } else {
            LOGGER.debug("Didn't discover namespace: {} in namespace registry.", (Object)namespace);
            ImmutableBiMap nsMap = ImmutableBiMap.copyOf(namespaceMapping);
            if (nsMap.containsValue((Object)namespace)) {
                LOGGER.debug("Discovered namespace: {} in namespace map: {}.", (Object)namespace, (Object)nsMap);
                prefix = (String)nsMap.inverse().get((Object)namespace);
                namespaceRegistry.registerNamespace(prefix, namespace);
            } else {
                prefix = namespaceRegistry.registerNamespace(namespace);
            }
        }
        String propertyName = prefix + ":" + rdfLocalname;
        LOGGER.debug("Took RDF predicate {} and translated it to JCR property {}", (Object)namespace, (Object)propertyName);
        return propertyName;
    }
}

