/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.identifiers.NodeResourceConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.PropertiesRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.TypeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyValueIterator;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.iterators.RdfStream;

public class BlankNodeRdfContext
extends NodeRdfContext {
    private static final List<Integer> referencePropertyTypes = Arrays.asList(8, 9, 10);
    private static final Predicate<Property> filterReferenceProperties = new Predicate<Property>(){

        public boolean apply(Property property) {
            try {
                int type = property.getType();
                return referencePropertyTypes.contains(type);
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };
    private final Function<Value, Node> getNodesForValue = new Function<Value, Node>(){

        public Node apply(Value v) {
            try {
                Node refNode = v.getType() == 8 ? BlankNodeRdfContext.this.resource().getNode().getSession().getNode(v.getString()) : BlankNodeRdfContext.this.resource().getNode().getSession().getNodeByIdentifier(v.getString());
                return refNode;
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    };

    public BlankNodeRdfContext(FedoraResource resource, final IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        this.concat(Iterators.concat((Iterator)Iterators.transform(this.getBlankNodesIterator(), (Function)new Function<Node, RdfStream>(){

            public RdfStream apply(Node node) {
                FedoraResource resource = (FedoraResource)NodeResourceConverter.nodeConverter.convert(node);
                return resource.getTriples(idTranslator, (Iterable)ImmutableList.of(TypeRdfContext.class, PropertiesRdfContext.class, BlankNodeRdfContext.class));
            }
        })));
    }

    private Iterator<Node> getBlankNodesIterator() throws RepositoryException {
        PropertyIterator properties = this.resource().getNode().getProperties();
        UnmodifiableIterator references = Iterators.filter((Iterator)properties, filterReferenceProperties);
        Iterator nodes = Iterators.transform((Iterator)((Object)new PropertyValueIterator((Iterator<Property>)references)), this.getNodesForValue);
        return Iterators.filter((Iterator)nodes, FedoraTypesUtils.isBlankNode);
    }
}

