/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.NodeFactory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.ResourceFactory;
import com.hp.hpl.jena.vocabulary.RDF;
import java.net.URI;
import java.util.Calendar;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.RdfLexicon;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.FixityResult;

public class FixityRdfContext
extends NodeRdfContext {
    public FixityRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator, Iterable<FixityResult> blobs, URI digest, long size) {
        super(resource, idTranslator);
        this.concat(Iterators.concat((Iterator)Iterators.transform(blobs.iterator(), (Function)new FixityResultIteratorFunction(resource, idTranslator, digest, size))));
    }

    private Node getTransientFixitySubject() {
        return NodeFactory.createURI((String)(this.subject().getURI() + "#fixity/" + Calendar.getInstance().getTimeInMillis()));
    }

    private class FixityResultIteratorFunction
    implements Function<FixityResult, Iterator<Triple>> {
        private final FedoraResource resource;
        private final IdentifierConverter<Resource, FedoraResource> idTranslator;
        private URI digest;
        private final long size;

        public FixityResultIteratorFunction(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator, URI digest, long size) {
            this.resource = resource;
            this.idTranslator = idTranslator;
            this.digest = digest;
            this.size = size;
        }

        public Iterator<Triple> apply(FixityResult blob) {
            Node resultSubject = FixityRdfContext.this.getTransientFixitySubject();
            ImmutableSet.Builder b = ImmutableSet.builder();
            try {
                b.add((Object)Triple.create((Node)((Resource)this.idTranslator.reverse().convert((Object)this.resource)).asNode(), (Node)RdfLexicon.HAS_FIXITY_RESULT.asNode(), (Node)resultSubject));
                b.add((Object)Triple.create((Node)resultSubject, (Node)RDF.type.asNode(), (Node)RdfLexicon.FIXITY_TYPE.asNode()));
                String storeIdentifier = blob.getStoreIdentifier();
                Node contentLocation = ResourceFactory.createResource((String)storeIdentifier).asNode();
                for (FixityResult.FixityState state : blob.getStatus(this.size, this.digest)) {
                    b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_FIXITY_STATE.asNode(), (Node)NodeFactory.createLiteral((String)state.toString())));
                }
                String checksum = blob.getComputedChecksum().toString();
                b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_MESSAGE_DIGEST.asNode(), (Node)NodeFactory.createURI((String)checksum)));
                b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_SIZE.asNode(), (Node)ResourceFactory.createTypedLiteral((Object)blob.getComputedSize()).asNode()));
                b.add((Object)Triple.create((Node)resultSubject, (Node)RdfLexicon.HAS_CONTENT_LOCATION.asNode(), (Node)contentLocation));
                b.add((Object)Triple.create((Node)contentLocation, (Node)RDF.type.asNode(), (Node)RdfLexicon.CONTENT_LOCATION_TYPE.asNode()));
                b.add((Object)Triple.create((Node)contentLocation, (Node)RdfLexicon.HAS_CONTENT_LOCATION_VALUE.asNode(), (Node)NodeFactory.createLiteral((String)storeIdentifier)));
                return b.build().iterator();
            }
            catch (RepositoryException e) {
                throw new RepositoryRuntimeException((Throwable)e);
            }
        }
    }
}

