/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl;

import com.google.common.base.Converter;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.impl.NodeRdfContext;
import org.fcrepo.kernel.impl.rdf.impl.mappings.PropertyToTriple;
import org.fcrepo.kernel.impl.utils.FedoraTypesUtils;
import org.fcrepo.kernel.models.FedoraBinary;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.models.NonRdfSourceDescription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesRdfContext
extends NodeRdfContext {
    private final PropertyToTriple property2triple;
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesRdfContext.class);

    public PropertiesRdfContext(FedoraResource resource, IdentifierConverter<Resource, FedoraResource> idTranslator) throws RepositoryException {
        super(resource, idTranslator);
        this.property2triple = new PropertyToTriple(resource.getNode().getSession(), (Converter<Resource, FedoraResource>)idTranslator);
        this.concat(this.triplesFromProperties(this.resource()));
    }

    private Iterator<Triple> triplesFromProperties(FedoraResource n) throws RepositoryException {
        Object allProperties;
        LOGGER.trace("Creating triples for node: {}", (Object)n);
        if (n instanceof FedoraBinary) {
            NonRdfSourceDescription description = ((FedoraBinary)n).getDescription();
            allProperties = Iterators.concat((Iterator)n.getNode().getProperties(), (Iterator)description.getNode().getProperties());
        } else {
            allProperties = n.getNode().getProperties();
        }
        UnmodifiableIterator properties = Iterators.filter((Iterator)allProperties, (Predicate)Predicates.not(FedoraTypesUtils.isInternalProperty));
        return Iterators.concat((Iterator)Iterators.transform((Iterator)properties, (Function)this.property2triple));
    }
}

