/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.rdf.impl.mappings;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.Iterator;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;

public class PropertyValueIterator
extends AbstractIterator<Value> {
    private final Iterator<Property> properties;
    private Iterator<Value> currentValues;

    public PropertyValueIterator(Iterator<Property> properties) {
        this.properties = properties;
        this.currentValues = null;
    }

    public PropertyValueIterator(Property property) {
        this.properties = Iterators.singletonIterator((Object)property);
        this.currentValues = null;
    }

    protected Value computeNext() {
        try {
            if (this.currentValues != null && this.currentValues.hasNext()) {
                return this.currentValues.next();
            }
            if (this.properties.hasNext()) {
                Property property = this.properties.next();
                if (property.isMultiple()) {
                    this.currentValues = Iterators.forArray((Object[])property.getValues());
                    return this.currentValues.next();
                }
                this.currentValues = null;
                return property.getValue();
            }
            return (Value)this.endOfData();
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }
}

