/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Throwables;
import java.io.File;
import javax.inject.Inject;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.impl.services.ServiceHelpers;
import org.fcrepo.kernel.services.RepositoryService;
import org.fcrepo.metrics.RegistryService;
import org.modeshape.jcr.api.Problems;
import org.modeshape.jcr.api.RepositoryManager;
import org.modeshape.jcr.api.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RepositoryServiceImpl
extends AbstractService
implements RepositoryService {
    @Inject
    private Repository repo;
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private final Timer objectSizeCalculationTimer = RegistryService.getInstance().getMetrics().timer(MetricRegistry.name(RepositoryService.class, (String[])new String[]{"objectSizeCalculation"}));

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Long getRepositorySize() {
        try {
            LOGGER.debug("Calculating repository size from index");
            try (Timer.Context context = this.objectSizeCalculationTimer.time();){
                Long l = ServiceHelpers.getRepositorySize(this.repo);
                return l;
            }
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Long getRepositoryObjectCount() {
        try {
            return ServiceHelpers.getRepositoryCount(this.repo);
        }
        catch (RepositoryException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public Problems backupRepository(javax.jcr.Session session, File backupDirectory) {
        try {
            RepositoryManager repoMgr = ((Session)session).getWorkspace().getRepositoryManager();
            return repoMgr.backupRepository(backupDirectory);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }

    public Problems restoreRepository(javax.jcr.Session session, File backupDirectory) {
        try {
            RepositoryManager repoMgr = ((Session)session).getWorkspace().getRepositoryManager();
            return repoMgr.restoreRepository(backupDirectory);
        }
        catch (RepositoryException e) {
            throw new RepositoryRuntimeException((Throwable)e);
        }
    }
}

