/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Workspace;
import javax.jcr.version.LabelExistsVersionException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import javax.jcr.version.VersionIterator;
import javax.jcr.version.VersionManager;
import org.fcrepo.kernel.impl.FedoraBinaryImpl;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.kernel.services.VersionService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class VersionServiceImpl
extends AbstractService
implements VersionService {
    private static final Logger LOGGER = LoggerFactory.getLogger(VersionService.class);
    private static final Pattern invalidLabelPattern = Pattern.compile("[~#@*+%{}<>\\[\\]|\"^]");

    public String createVersion(Session session, String absPath, String label) throws RepositoryException {
        Node node = session.getNode(absPath);
        if (!VersionServiceImpl.isVersioningEnabled(node)) {
            VersionServiceImpl.enableVersioning(node);
        }
        return VersionServiceImpl.checkpoint(session, absPath, label);
    }

    public void revertToVersion(Session session, String absPath, String label) throws RepositoryException {
        Workspace workspace = session.getWorkspace();
        Version v = VersionServiceImpl.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        VersionManager versionManager = workspace.getVersionManager();
        Version preRevertVersion = versionManager.checkin(absPath);
        try {
            preRevertVersion.getContainingHistory().addVersionLabel(preRevertVersion.getName(), VersionServiceImpl.getPreRevertVersionLabel(label, preRevertVersion.getContainingHistory()), false);
        }
        catch (LabelExistsVersionException e) {
            // empty catch block
        }
        versionManager.restore(v, true);
        versionManager.checkout(absPath);
    }

    private static String getPreRevertVersionLabel(String targetLabel, VersionHistory history) throws RepositoryException {
        String baseLabel = "auto-snapshot-before-" + targetLabel;
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            String label = baseLabel + (i == 0 ? "" : "-" + i);
            if (history.hasVersionLabel(label)) continue;
            return label;
        }
        return baseLabel;
    }

    public void removeVersion(Session session, String absPath, String label) throws RepositoryException {
        String[] versionLabels;
        Workspace workspace = session.getWorkspace();
        Version v = VersionServiceImpl.getVersionForLabel(workspace, absPath, label);
        if (v == null) {
            throw new PathNotFoundException("Unknown version \"" + label + "\"!");
        }
        if (workspace.getVersionManager().getBaseVersion(absPath).equals(v)) {
            throw new VersionException("Cannot remove most recent version snapshot.");
        }
        VersionHistory history = v.getContainingHistory();
        for (String versionLabel : versionLabels = history.getVersionLabels(v)) {
            LOGGER.debug("Removing label: {}", (Object)versionLabel);
            history.removeVersionLabel(versionLabel);
        }
        history.removeVersion(v.getName());
    }

    private static Version getVersionForLabel(Workspace workspace, String absPath, String label) throws RepositoryException {
        VersionHistory history = workspace.getVersionManager().getVersionHistory(absPath);
        if (history.hasVersionLabel(label)) {
            return history.getVersionByLabel(label);
        }
        VersionIterator versionIt = history.getAllVersions();
        if (versionIt == null) {
            return null;
        }
        while (versionIt.hasNext()) {
            Version v = versionIt.nextVersion();
            if (!v.getFrozenNode().getIdentifier().equals(label)) continue;
            return v;
        }
        return null;
    }

    private static boolean isVersioningEnabled(Node n) throws RepositoryException {
        return n.isNodeType("mix:versionable") || FedoraBinaryImpl.hasMixin(n) && VersionServiceImpl.isVersioningEnabled(n.getParent());
    }

    private static void enableVersioning(Node node) throws RepositoryException {
        node.addMixin("mix:versionable");
        if (FedoraBinaryImpl.hasMixin(node)) {
            node.getParent().addMixin("mix:versionable");
        }
        node.getSession().save();
    }

    private static String checkpoint(Session session, String absPath, String label) throws RepositoryException {
        if (!VersionServiceImpl.validLabel(label)) {
            throw new VersionException("Invalid label: " + label);
        }
        LOGGER.trace("Setting version checkpoint for {}", (Object)absPath);
        Workspace workspace = session.getWorkspace();
        VersionManager versionManager = workspace.getVersionManager();
        VersionHistory versionHistory = versionManager.getVersionHistory(absPath);
        if (versionHistory.hasVersionLabel(label)) {
            throw new LabelExistsVersionException("The specified label \"" + label + "\" is already assigned to another version of this resource!");
        }
        Version v = versionManager.checkpoint(absPath);
        if (v == null) {
            return null;
        }
        versionHistory.addVersionLabel(v.getName(), label, false);
        return v.getFrozenNode().getIdentifier();
    }

    private static boolean validLabel(String label) {
        Matcher matcher = invalidLabelPattern.matcher(label);
        return !matcher.find();
    }
}

