/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.utils.iterators;

import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.fcrepo.kernel.exception.MalformedRdfException;
import org.fcrepo.kernel.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.identifiers.IdentifierConverter;
import org.fcrepo.kernel.impl.rdf.JcrRdfTools;
import org.fcrepo.kernel.impl.rdf.ManagedRdf;
import org.fcrepo.kernel.models.FedoraResource;
import org.fcrepo.kernel.utils.iterators.RdfStream;
import org.fcrepo.kernel.utils.iterators.RdfStreamConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PersistingRdfStreamConsumer
implements RdfStreamConsumer {
    private final RdfStream stream;
    private final IdentifierConverter<Resource, FedoraResource> idTranslator;
    protected final Predicate<Triple> isFedoraSubjectTriple;
    private final JcrRdfTools jcrRdfTools;
    private static final Model m = ModelFactory.createDefaultModel();
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistingRdfStreamConsumer.class);
    private final List<String> exceptions;

    public PersistingRdfStreamConsumer(final IdentifierConverter<Resource, FedoraResource> idTranslator, Session session, RdfStream stream) {
        this.idTranslator = idTranslator;
        this.jcrRdfTools = new JcrRdfTools(idTranslator, session);
        this.isFedoraSubjectTriple = new Predicate<Triple>(){

            public boolean apply(Triple t) {
                boolean result;
                boolean bl = result = idTranslator.inDomain((Object)m.asStatement(t).getSubject()) || t.getSubject().isBlank();
                if (result) {
                    LOGGER.debug("Discovered a Fedora-relevant subject in triple: {}.", (Object)t);
                } else {
                    LOGGER.debug("Ignoring triple: {}.", (Object)t);
                }
                return result;
            }
        };
        this.stream = stream.withThisContext((Iterator)stream.filter(this.isFedoraSubjectTriple));
        this.exceptions = new ArrayList<String>();
    }

    public void consume() throws MalformedRdfException {
        while (this.stream.hasNext()) {
            Statement t = m.asStatement((Triple)this.stream.next());
            LOGGER.debug("Operating triple {}.", (Object)t);
            try {
                this.operateOnTriple(t);
            }
            catch (MalformedRdfException e) {
                this.exceptions.add(e.getMessage());
            }
        }
        if (!this.exceptions.isEmpty()) {
            throw new MalformedRdfException(Joiner.on((String)"\n").join(this.exceptions));
        }
    }

    protected void operateOnTriple(Statement input) throws MalformedRdfException {
        try {
            Statement t = this.jcrRdfTools.skolemize(this.idTranslator, input);
            Resource subject = t.getSubject();
            FedoraResource subjectNode = (FedoraResource)this.translator().convert((Object)subject);
            if (t.getPredicate().equals(RDF.type) && t.getObject().isResource()) {
                Resource mixinResource = t.getObject().asResource();
                if (!ManagedRdf.isManagedMixin.apply((Object)mixinResource)) {
                    LOGGER.debug("Operating on node: {} with mixin: {}.", (Object)subjectNode, (Object)mixinResource);
                    this.operateOnMixin(mixinResource, subjectNode);
                } else {
                    LOGGER.debug("Found repository-managed mixin on which we will not operate.");
                }
            } else {
                LOGGER.debug("Operating on node: {} from triple: {}.", (Object)subjectNode, (Object)t);
                this.operateOnProperty(t, subjectNode);
            }
        }
        catch (RepositoryException | RepositoryRuntimeException e) {
            throw new MalformedRdfException(e.getMessage(), e);
        }
    }

    protected abstract void operateOnProperty(Statement var1, FedoraResource var2) throws RepositoryException;

    protected abstract void operateOnMixin(Resource var1, FedoraResource var2) throws RepositoryException;

    public ListenableFuture<Boolean> consumeAsync() {
        SettableFuture result = SettableFuture.create();
        try {
            this.consume();
            result.set((Object)true);
        }
        catch (MalformedRdfException e) {
            LOGGER.warn("Got exception consuming RDF stream", (Throwable)e);
            result.setException((Throwable)e);
            result.set((Object)false);
        }
        return result;
    }

    public RdfStream stream() {
        return this.stream;
    }

    public IdentifierConverter<Resource, FedoraResource> translator() {
        return this.idTranslator;
    }

    public JcrRdfTools jcrRdfTools() {
        return this.jcrRdfTools;
    }
}

