/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.operations;

import java.time.Instant;
import java.util.Calendar;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Resource;
import org.fcrepo.config.ServerManagedPropsMode;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.RdfSourceOperationBuilder;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.utils.RelaxedPropertiesHelper;

public abstract class AbstractRdfSourceOperationBuilder
implements RdfSourceOperationBuilder {
    protected RdfStream tripleStream;
    protected final FedoraId resourceId;
    protected final String interactionModel;
    protected String userPrincipal;
    protected String lastModifiedBy;
    protected String createdBy;
    protected Instant lastModifiedDate;
    protected Instant createdDate;
    protected ServerManagedPropsMode serverManagedPropsMode;
    protected Transaction transaction;

    protected AbstractRdfSourceOperationBuilder(Transaction transaction, FedoraId rescId, String model, ServerManagedPropsMode serverManagedPropsMode) {
        this.transaction = transaction;
        this.resourceId = rescId;
        this.interactionModel = model;
        this.serverManagedPropsMode = serverManagedPropsMode;
    }

    public RdfSourceOperationBuilder userPrincipal(String userPrincipal) {
        this.userPrincipal = userPrincipal;
        return this;
    }

    public RdfSourceOperationBuilder triples(RdfStream triples) {
        this.tripleStream = this.serverManagedPropsMode.equals((Object)ServerManagedPropsMode.RELAXED) ? new DefaultRdfStream(triples.topic(), triples.filter(t -> {
            try {
                RelaxedPropertiesHelper.checkTripleForDisallowed((Triple)t);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        })) : triples;
        return this;
    }

    public RdfSourceOperationBuilder relaxedProperties(Model model) {
        if (model != null && this.serverManagedPropsMode == ServerManagedPropsMode.RELAXED) {
            String modifiedBy;
            Calendar modifiedDate;
            String createdByVal;
            Resource resc = model.getResource(this.resourceId.getResourceId());
            Calendar createdDateVal = RelaxedPropertiesHelper.getCreatedDate((Resource)resc);
            if (createdDateVal != null) {
                this.createdDate = createdDateVal.toInstant();
            }
            if ((createdByVal = RelaxedPropertiesHelper.getCreatedBy((Resource)resc)) != null) {
                this.createdBy = createdByVal;
            }
            if ((modifiedDate = RelaxedPropertiesHelper.getModifiedDate((Resource)resc)) != null) {
                this.lastModifiedDate = modifiedDate.toInstant();
            }
            if ((modifiedBy = RelaxedPropertiesHelper.getModifiedBy((Resource)resc)) != null) {
                this.lastModifiedBy = modifiedBy;
            }
        }
        return this;
    }
}

