/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.fcrepo.config.OcflPropsConfig;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.models.Container;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.Tombstone;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.impl.services.MembershipIndexManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MembershipServiceImpl
implements MembershipService {
    private static final Logger log = LoggerFactory.getLogger(MembershipServiceImpl.class);
    public static final Instant NO_END_INSTANT = Instant.parse("9999-12-31T00:00:00.000Z");
    @Inject
    private MembershipIndexManager indexManager;
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private OcflPropsConfig propsConfig;

    public void resourceCreated(Transaction tx, FedoraId fedoraId) {
        FedoraResource fedoraResc = this.getFedoraResource(tx, fedoraId);
        if (!(fedoraResc instanceof Container) && !(fedoraResc instanceof Binary)) {
            return;
        }
        FedoraResource parentResc = this.getParentResource(fedoraResc);
        DirectContainerProperties containerProperties = new DirectContainerProperties(parentResc);
        if (containerProperties.containerType != null) {
            Triple newMembership = this.generateMembership(containerProperties, fedoraResc);
            this.indexManager.addMembership(tx, parentResc.getFedoraId(), fedoraResc.getFedoraId(), newMembership, fedoraResc.getCreatedDate());
        }
    }

    public void resourceModified(Transaction tx, FedoraId fedoraId) {
        FedoraResource fedoraResc = this.getFedoraResource(tx, fedoraId);
        DirectContainerProperties containerProperties = new DirectContainerProperties(fedoraResc);
        if (containerProperties.containerType != null) {
            log.debug("Modified DirectContainer {}, recomputing generated membership relations", (Object)fedoraId);
            if (this.propsConfig.isAutoVersioningEnabled()) {
                this.modifyDCAutoversioned(tx, fedoraResc, containerProperties);
            } else {
                this.modifyDCOnDemandVersioning(tx, fedoraResc);
            }
        }
        FedoraResource parentResc = this.getParentResource(fedoraResc);
        DirectContainerProperties parentProperties = new DirectContainerProperties(parentResc);
        if (ContainerType.Indirect.equals((Object)parentProperties.containerType)) {
            this.modifyProxy(tx, fedoraResc, parentProperties);
        }
    }

    private void modifyProxy(Transaction tx, FedoraResource proxyResc, DirectContainerProperties containerProperties) {
        Instant lastModified = proxyResc.getLastModifiedDate();
        if (this.propsConfig.isAutoVersioningEnabled()) {
            this.indexManager.endMembershipFromChild(tx, containerProperties.id, proxyResc.getFedoraId(), lastModified);
        } else {
            List mementoDatetimes = proxyResc.getTimeMap().listMementoDatetimes();
            Instant lastVersionDatetime = mementoDatetimes.size() == 0 ? null : (Instant)mementoDatetimes.get(mementoDatetimes.size() - 1);
            this.indexManager.deleteMembershipForProxyAfter(tx, containerProperties.id, proxyResc.getFedoraId(), lastVersionDatetime);
        }
        this.indexManager.addMembership(tx, containerProperties.id, proxyResc.getFedoraId(), this.generateMembership(containerProperties, proxyResc), lastModified);
    }

    private void modifyDCAutoversioned(Transaction tx, FedoraResource dcResc, DirectContainerProperties containerProperties) {
        FedoraId dcId = dcResc.getFedoraId();
        Instant dcLastModified = dcResc.getLastModifiedDate();
        this.indexManager.endMembershipForSource(tx, dcResc.getFedoraId(), dcLastModified);
        dcResc.getChildren().filter(child -> !(child instanceof Tombstone)).forEach(child -> {
            Triple newMembership = this.generateMembership(containerProperties, (FedoraResource)child);
            this.indexManager.addMembership(tx, dcId, child.getFedoraId(), newMembership, dcLastModified);
        });
    }

    private void modifyDCOnDemandVersioning(Transaction tx, FedoraResource dcResc) {
        FedoraId dcId = dcResc.getFedoraId();
        List mementoDatetimes = dcResc.getTimeMap().listMementoDatetimes();
        Instant lastVersionDatetime = mementoDatetimes.size() == 0 ? null : (Instant)mementoDatetimes.get(mementoDatetimes.size() - 1);
        this.indexManager.deleteMembershipForSourceAfter(tx, dcId, lastVersionDatetime);
        this.populateMembershipHistory(tx, dcResc, lastVersionDatetime);
    }

    private Triple generateMembership(DirectContainerProperties properties, FedoraResource childResc) {
        Node memberNode;
        Resource childRdfResc = this.getRdfResource(childResc.getFedoraId());
        if (ContainerType.Indirect.equals((Object)properties.containerType)) {
            if (RdfLexicon.MEMBER_SUBJECT.equals(properties.insertedContentRelation)) {
                memberNode = childRdfResc.asNode();
            } else {
                Resource childModelResc = this.getRdfResource(childResc);
                Statement stmt = childModelResc.getProperty(properties.insertedContentRelation);
                if (stmt == null || !(stmt.getObject() instanceof Resource)) {
                    return null;
                }
                memberNode = stmt.getResource().asNode();
            }
        } else {
            memberNode = childRdfResc.asNode();
        }
        return this.generateMembershipTriple(properties.membershipResource, memberNode, properties.hasMemberRelation, properties.isMemberOfRelation);
    }

    private Triple generateMembershipTriple(Node membership, Node member, Node hasMemberRel, Node memberOfRel) {
        if (memberOfRel != null) {
            return new Triple(member, memberOfRel, membership);
        }
        return new Triple(membership, hasMemberRel, member);
    }

    private Resource getRdfResource(FedoraResource fedoraResc) {
        Model model = (Model)fedoraResc.getTriples().collect(RdfCollectors.toModel());
        return model.getResource(fedoraResc.getFedoraId().getFullId());
    }

    private Resource getRdfResource(FedoraId fedoraId) {
        return org.apache.jena.rdf.model.ResourceFactory.createResource((String)fedoraId.getFullId());
    }

    private FedoraResource getFedoraResource(Transaction transaction, FedoraId fedoraId) {
        try {
            return this.resourceFactory.getResource(transaction, fedoraId);
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private FedoraResource getParentResource(FedoraResource resc) {
        try {
            return resc.getParent();
        }
        catch (PathNotFoundException e) {
            throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    public void resourceDeleted(@Nonnull Transaction transaction, FedoraId fedoraId) {
        FedoraResource parentResc;
        ContainerType parentContainerType;
        ContainerType resourceContainerType;
        FedoraResource fedoraResc;
        try {
            fedoraResc = this.getFedoraResource(transaction, fedoraId);
        }
        catch (PathNotFoundRuntimeException e) {
            log.debug("Deleted resource {} does not have a tombstone, cleanup any references", (Object)fedoraId);
            this.indexManager.deleteMembershipReferences(transaction.getId(), fedoraId);
            return;
        }
        if (fedoraResc instanceof Tombstone) {
            fedoraResc = ((Tombstone)fedoraResc).getDeletedObject();
        }
        if ((resourceContainerType = MembershipServiceImpl.getContainerType(fedoraResc)) != null) {
            log.debug("Ending membership for deleted Direct/IndirectContainer {} in {}", (Object)fedoraId, (Object)transaction);
            this.indexManager.endMembershipForSource(transaction, fedoraId, fedoraResc.getLastModifiedDate());
        }
        if ((parentContainerType = MembershipServiceImpl.getContainerType(parentResc = this.getParentResource(fedoraResc))) != null) {
            log.debug("Ending membership for deleted proxy or member in tx {} for {} at {}", new Object[]{transaction, parentResc.getFedoraId(), fedoraResc.getLastModifiedDate()});
            this.indexManager.endMembershipFromChild(transaction, parentResc.getFedoraId(), fedoraResc.getFedoraId(), fedoraResc.getLastModifiedDate());
        }
    }

    public RdfStream getMembership(Transaction tx, FedoraId fedoraId) {
        FedoraId subjectId = fedoraId.isDescription() ? fedoraId.asBaseId() : fedoraId;
        Node subject = NodeFactory.createURI((String)subjectId.getBaseId());
        Stream<Triple> membershipStream = this.indexManager.getMembership(tx, subjectId);
        return new DefaultRdfStream(subject, membershipStream);
    }

    public void commitTransaction(Transaction tx) {
        this.indexManager.commitTransaction(tx);
    }

    public void rollbackTransaction(Transaction tx) {
        this.indexManager.deleteTransaction(tx);
    }

    public void reset() {
        this.indexManager.clearIndex();
    }

    public void populateMembershipHistory(@Nonnull Transaction transaction, FedoraId containerId) {
        FedoraResource fedoraResc = this.getFedoraResource(transaction, containerId);
        ContainerType containerType = MembershipServiceImpl.getContainerType(fedoraResc);
        if (containerType != null) {
            this.populateMembershipHistory(transaction, fedoraResc, null);
        }
    }

    private void populateMembershipHistory(Transaction tx, FedoraResource fedoraResc, Instant afterTime) {
        FedoraId containerId = fedoraResc.getFedoraId();
        List<DirectContainerProperties> propertyTimeline = this.makePropertyTimeline(fedoraResc);
        List<DirectContainerProperties> timeline = afterTime != null ? propertyTimeline.stream().filter(e -> e.startDatetime.compareTo(afterTime) >= 0 || e.endDatetime.compareTo(afterTime) >= 0).collect(Collectors.toList()) : propertyTimeline;
        fedoraResc.getChildren().forEach(member -> {
            boolean memberDeleted = member instanceof Tombstone;
            log.debug("Populating membership history for DirectContainer {}member {}", (Object)(memberDeleted ? "deleted " : ""), (Object)member.getFedoraId());
            Instant memberCreated = memberDeleted ? ((Tombstone)member).getDeletedObject().getCreatedDate() : member.getCreatedDate();
            Instant memberModified = member.getLastModifiedDate();
            Instant memberEnd = memberDeleted ? memberModified : NO_END_INSTANT;
            Stream<DirectContainerProperties> timelineStream = timeline.stream().filter(e -> e.endDatetime.compareTo(memberCreated) > 0);
            if (memberDeleted) {
                timelineStream = timelineStream.filter(e -> e.startDatetime.compareTo(memberModified) < 0);
            }
            timelineStream.forEach(e -> this.indexManager.addMembership(tx, containerId, member.getFedoraId(), this.generateMembership((DirectContainerProperties)e, (FedoraResource)member), this.instantMax(memberCreated, e.startDatetime), this.instantMin(memberEnd, e.endDatetime)));
        });
    }

    private Instant instantMax(Instant first, Instant second) {
        if (first.isAfter(second)) {
            return first;
        }
        return second;
    }

    private Instant instantMin(Instant first, Instant second) {
        if (first.isBefore(second)) {
            return first;
        }
        return second;
    }

    private List<DirectContainerProperties> makePropertyTimeline(FedoraResource fedoraResc) {
        ArrayList entryList = fedoraResc.getTimeMap().getChildren().map(memento -> new DirectContainerProperties((FedoraResource)memento)).collect(Collectors.toCollection(ArrayList::new));
        if (!this.propsConfig.isAutoVersioningEnabled()) {
            entryList.add(new DirectContainerProperties(fedoraResc));
        }
        ((DirectContainerProperties)entryList.get((int)0)).startDatetime = fedoraResc.getCreatedDate();
        ArrayList<DirectContainerProperties> changeEntries = new ArrayList<DirectContainerProperties>();
        DirectContainerProperties curr = (DirectContainerProperties)entryList.get(0);
        changeEntries.add(curr);
        for (int i = 1; i < entryList.size(); ++i) {
            DirectContainerProperties next = (DirectContainerProperties)entryList.get(i);
            if (Objects.equals(next.membershipResource, curr.membershipResource) && Objects.equals(next.hasMemberRelation, curr.hasMemberRelation) && Objects.equals(next.isMemberOfRelation, curr.isMemberOfRelation)) continue;
            curr.endDatetime = next.startDatetime;
            changeEntries.add(next);
            curr = next;
        }
        return changeEntries;
    }

    private static ContainerType getContainerType(FedoraResource fedoraResc) {
        if (!(fedoraResc instanceof Container)) {
            return null;
        }
        if (fedoraResc.hasType(RdfLexicon.INDIRECT_CONTAINER.getURI())) {
            return ContainerType.Indirect;
        }
        if (fedoraResc.hasType(RdfLexicon.DIRECT_CONTAINER.getURI())) {
            return ContainerType.Direct;
        }
        return null;
    }

    public Instant getLastUpdatedTimestamp(Transaction transaction, FedoraId fedoraId) {
        return this.indexManager.getLastUpdated(transaction, fedoraId);
    }

    public void setMembershipIndexManager(MembershipIndexManager indexManager) {
        this.indexManager = indexManager;
    }

    public void setResourceFactory(ResourceFactory resourceFactory) {
        this.resourceFactory = resourceFactory;
    }

    private static class DirectContainerProperties {
        public Node membershipResource;
        public Node hasMemberRelation;
        public Node isMemberOfRelation;
        public Property insertedContentRelation;
        public FedoraId id;
        public ContainerType containerType;
        public Instant startDatetime;
        public Instant endDatetime = NO_END_INSTANT;

        public DirectContainerProperties(FedoraResource fedoraResc) {
            this.containerType = MembershipServiceImpl.getContainerType(fedoraResc);
            if (this.containerType == null) {
                return;
            }
            this.id = fedoraResc.getFedoraId();
            this.startDatetime = fedoraResc.isMemento() ? fedoraResc.getMementoDatetime() : fedoraResc.getLastModifiedDate();
            fedoraResc.getTriples().forEach(triple -> {
                if (RdfLexicon.MEMBERSHIP_RESOURCE.asNode().equals((Object)triple.getPredicate())) {
                    this.membershipResource = triple.getObject();
                } else if (RdfLexicon.HAS_MEMBER_RELATION.asNode().equals((Object)triple.getPredicate())) {
                    this.hasMemberRelation = triple.getObject();
                } else if (RdfLexicon.IS_MEMBER_OF_RELATION.asNode().equals((Object)triple.getPredicate())) {
                    this.isMemberOfRelation = triple.getObject();
                } else if (RdfLexicon.INSERTED_CONTENT_RELATION.asNode().equals((Object)triple.getPredicate())) {
                    this.insertedContentRelation = org.apache.jena.rdf.model.ResourceFactory.createProperty((String)triple.getObject().getURI());
                }
            });
            if (this.hasMemberRelation == null && this.isMemberOfRelation == null) {
                this.hasMemberRelation = RdfLexicon.LDP_MEMBER.asNode();
            }
        }
    }

    private static enum ContainerType {
        Direct,
        Indirect;

    }
}

