/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import com.google.common.base.Preconditions;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import org.fcrepo.common.db.DbPlatform;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="containmentIndexImpl")
public class ContainmentIndexImpl
implements ContainmentIndex {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContainmentIndexImpl.class);
    @Inject
    private DataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private DbPlatform dbPlatform;
    public static final String RESOURCES_TABLE = "containment";
    private static final String TRANSACTION_OPERATIONS_TABLE = "containment_transactions";
    public static final String FEDORA_ID_COLUMN = "fedora_id";
    private static final String PARENT_COLUMN = "parent";
    private static final String TRANSACTION_ID_COLUMN = "transaction_id";
    private static final String OPERATION_COLUMN = "operation";
    private static final String START_TIME_COLUMN = "start_time";
    private static final String END_TIME_COLUMN = "end_time";
    private static final String SELECT_CHILDREN = "SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NULL";
    private static final String SELECT_CHILDREN_OF_MEMENTO = "SELECT fedora_id FROM containment WHERE parent = :parent AND start_time <= :asOfTime AND (end_time > :asOfTime OR end_time IS NULL)";
    private static final String SELECT_CHILDREN_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NULL  UNION SELECT fedora_id FROM containment_transactions WHERE parent = :parent AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE parent = :parent AND fedora_id = x.fedora_id AND transaction_id = :transactionId AND operation IN ('delete', 'purge'))";
    private static final String SELECT_DELETED_CHILDREN = "SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NOT NULL";
    private static final String SELECT_DELETED_CHILDREN_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE parent = :parent AND end_time IS NOT NULL UNION SELECT fedora_id FROM containment_transactions WHERE parent = :parent AND transaction_id = :transactionId AND operation = 'delete') x WHERE NOT EXISTS (SELECT 1 FROM containment_transactions WHERE parent = :parent AND fedora_id = x.fedora_id AND transaction_id = :transactionId AND operation = 'add')";
    private static final String INSERT_CHILD_IN_TRANSACTION = "INSERT INTO containment_transactions ( parent, fedora_id, start_time, end_time, transaction_id, operation ) VALUES (:parent, :child, :startTime, :endTime, :transactionId, 'add')";
    private static final String UNDO_INSERT_CHILD_IN_TRANSACTION = "DELETE FROM containment_transactions WHERE parent = :parent AND fedora_id = :child AND transaction_id = :transactionId AND operation = 'add'";
    private static final String DELETE_CHILD_IN_TRANSACTION = "INSERT INTO containment_transactions ( parent, fedora_id, end_time, transaction_id, operation ) VALUES (:parent, :child, :endTime, :transactionId, 'delete')";
    private static final String PURGE_CHILD_IN_TRANSACTION = "INSERT INTO containment_transactions ( parent, fedora_id, transaction_id, operation ) VALUES (:parent, :child, :transactionId, 'purge')";
    private static final String UNDO_DELETE_CHILD_IN_TRANSACTION_NO_PARENT = "DELETE FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'delete'";
    private static final String UNDO_PURGE_CHILD_IN_TRANSACTION = "DELETE FROM containment_transactions WHERE parent = :parent AND fedora_id = :child AND transaction_id = :transactionId AND operation = 'purge'";
    private static final String IS_CHILD_ADDED_IN_TRANSACTION = "SELECT TRUE FROM containment_transactions WHERE fedora_id = :child AND parent = :parent AND transaction_id = :transactionId AND operation = 'add'";
    private static final String IS_CHILD_DELETED_IN_TRANSACTION_NO_PARENT = "SELECT TRUE FROM containment_transactions WHERE fedora_id = :child  AND transaction_id = :transactionId AND operation = 'delete'";
    private static final String IS_CHILD_PURGED_IN_TRANSACTION = "SELECT TRUE FROM containment_transactions WHERE fedora_id = :child AND parent = :parent AND transaction_id = :transactionId AND operation = 'purge'";
    private static final String DELETE_ENTIRE_TRANSACTION = "DELETE FROM containment_transactions WHERE transaction_id = :transactionId";
    private static final String COMMIT_ADD_RECORDS = "INSERT INTO containment ( fedora_id, parent, start_time, end_time ) SELECT fedora_id, parent, start_time, end_time FROM containment_transactions WHERE transaction_id = :transactionId AND operation = 'add'";
    private static final String COMMIT_DELETE_RECORDS_H2 = "UPDATE containment r SET r.end_time = ( SELECT t.end_time FROM containment_transactions t  WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL) WHERE EXISTS (SELECT * FROM containment_transactions t WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL)";
    private static final String COMMIT_DELETE_RECORDS_MYSQL = "UPDATE containment r INNER JOIN containment_transactions t ON t.fedora_id = r.fedora_id SET r.end_time = t.end_time, r.start_time = r.start_time WHERE t.parent = r.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND r.end_time IS NULL";
    private static final String COMMIT_DELETE_RECORDS_POSTGRES = "UPDATE containment SET end_time = t.end_time FROM containment_transactions t WHERE t.fedora_id = containment.fedora_id AND t.parent = containment.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND containment.end_time IS NULL";
    private Map<DbPlatform, String> COMMIT_DELETE_RECORDS = Map.of(DbPlatform.H2, "UPDATE containment r SET r.end_time = ( SELECT t.end_time FROM containment_transactions t  WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL) WHERE EXISTS (SELECT * FROM containment_transactions t WHERE t.fedora_id = r.fedora_id AND t.transaction_id = :transactionId AND t.operation = 'delete' AND t.parent = r.parent AND r.end_time IS NULL)", DbPlatform.MARIADB, "UPDATE containment r INNER JOIN containment_transactions t ON t.fedora_id = r.fedora_id SET r.end_time = t.end_time, r.start_time = r.start_time WHERE t.parent = r.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND r.end_time IS NULL", DbPlatform.MYSQL, "UPDATE containment r INNER JOIN containment_transactions t ON t.fedora_id = r.fedora_id SET r.end_time = t.end_time, r.start_time = r.start_time WHERE t.parent = r.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND r.end_time IS NULL", DbPlatform.POSTGRESQL, "UPDATE containment SET end_time = t.end_time FROM containment_transactions t WHERE t.fedora_id = containment.fedora_id AND t.parent = containment.parent AND t.transaction_id = :transactionId AND t.operation = 'delete' AND containment.end_time IS NULL");
    private static final String COMMIT_PURGE_RECORDS = "DELETE FROM containment WHERE EXISTS (SELECT * FROM containment_transactions t WHERE t.transaction_id = :transactionId AND t.operation = 'purge' AND t.fedora_id = containment.fedora_id AND t.parent = containment.parent)";
    private static final String RESOURCE_EXISTS = "SELECT fedora_id FROM containment WHERE fedora_id = :child AND end_time IS NULL";
    private static final String RESOURCE_EXISTS_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE fedora_id = :child  AND end_time IS NULL UNION SELECT fedora_id FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation IN ('delete', 'purge'))";
    private static final String RESOURCE_OR_TOMBSTONE_EXISTS = "SELECT fedora_id FROM containment WHERE fedora_id = :child";
    private static final String RESOURCE_OR_TOMBSTONE_EXISTS_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE fedora_id = :child UNION SELECT fedora_id FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation IN ('delete', 'purge'))";
    private static final String PARENT_EXISTS = "SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NULL";
    private static final String PARENT_EXISTS_IN_TRANSACTION = "SELECT x.parent FROM (SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NULL UNION SELECT parent FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'delete')";
    private static final String PARENT_EXISTS_DELETED = "SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NOT NULL";
    private static final String PARENT_EXISTS_DELETED_IN_TRANSACTION = "SELECT x.parent FROM (SELECT parent FROM containment WHERE fedora_id = :child AND end_time IS NOT NULL UNION SELECT parent FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'delete') x WHERE NOT EXISTS  (SELECT 1 FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add')";
    private static final String IS_CHILD_ADDED_IN_TRANSACTION_NO_PARENT = "SELECT TRUE FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add'";
    private static final String UNDO_INSERT_CHILD_IN_TRANSACTION_NO_PARENT = "DELETE FROM containment_transactions WHERE fedora_id = :child AND transaction_id = :transactionId AND operation = 'add'";
    private static final String TRUNCATE_TABLE = "TRUNCATE TABLE ";
    private static final String SELECT_ID_LIKE = "SELECT fedora_id FROM containment WHERE fedora_id LIKE :resourceId";
    private static final String SELECT_ID_LIKE_IN_TRANSACTION = "SELECT x.fedora_id FROM (SELECT fedora_id FROM containment WHERE fedora_id LIKE :resourceId UNION SELECT fedora_id FROM containment_transactions WHERE fedora_id LIKE :resourceId AND transaction_id = :transactionId AND operation = 'add') x WHERE NOT EXISTS (SELECT 1 FROM containment_transactions WHERE fedora_id LIKE :resourceId AND transaction_id = :transactionId AND operation = 'delete')";
    private static final Map<DbPlatform, String> DDL_MAP = Map.of(DbPlatform.MYSQL, "sql/mysql-containment.sql", DbPlatform.H2, "sql/default-containment.sql", DbPlatform.POSTGRESQL, "sql/postgres-containment.sql", DbPlatform.MARIADB, "sql/default-containment.sql");

    @PostConstruct
    private void setup() {
        this.jdbcTemplate = this.getNamedParameterJdbcTemplate();
        this.dbPlatform = DbPlatform.fromDataSource((DataSource)this.dataSource);
        Preconditions.checkArgument((boolean)DDL_MAP.containsKey(this.dbPlatform), (String)"Missing DDL mapping for %s", (Object)this.dbPlatform);
        String ddl = DDL_MAP.get(this.dbPlatform);
        LOGGER.info("Applying ddl: {}", (Object)ddl);
        DatabasePopulatorUtils.execute((DatabasePopulator)new ResourceDatabasePopulator(new Resource[]{new DefaultResourceLoader().getResource("classpath:" + ddl)}), (DataSource)this.dataSource);
    }

    private NamedParameterJdbcTemplate getNamedParameterJdbcTemplate() {
        return new NamedParameterJdbcTemplate(this.getDataSource());
    }

    public Stream<String> getContains(String txId, FedoraId fedoraId) {
        List children;
        String resourceId = fedoraId.isMemento() ? fedoraId.getBaseId() : fedoraId.getFullId();
        Instant asOfTime = fedoraId.isMemento() ? fedoraId.getMementoInstant() : null;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(PARENT_COLUMN, (Object)resourceId);
        if (asOfTime == null) {
            if (txId != null) {
                parameterSource.addValue("transactionId", (Object)txId);
                children = this.jdbcTemplate.queryForList(SELECT_CHILDREN_IN_TRANSACTION, (SqlParameterSource)parameterSource, String.class);
            } else {
                children = this.jdbcTemplate.queryForList(SELECT_CHILDREN, (SqlParameterSource)parameterSource, String.class);
            }
        } else {
            parameterSource.addValue("asOfTime", (Object)this.formatInstant(asOfTime));
            children = this.jdbcTemplate.queryForList(SELECT_CHILDREN_OF_MEMENTO, (SqlParameterSource)parameterSource, String.class);
        }
        LOGGER.debug("getContains for {} in transaction {} and instant {} found {} children", new Object[]{resourceId, txId, asOfTime, children.size()});
        return children.stream();
    }

    public Stream<String> getContainsDeleted(String txId, FedoraId fedoraId) {
        List children;
        String resourceId = fedoraId.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(PARENT_COLUMN, (Object)resourceId);
        if (txId != null) {
            parameterSource.addValue("transactionId", (Object)txId);
            children = this.jdbcTemplate.queryForList(SELECT_DELETED_CHILDREN_IN_TRANSACTION, (SqlParameterSource)parameterSource, String.class);
        } else {
            children = this.jdbcTemplate.queryForList(SELECT_DELETED_CHILDREN, (SqlParameterSource)parameterSource, String.class);
        }
        LOGGER.debug("getContainsDeleted for {} in transaction {} found {} children", new Object[]{resourceId, txId, children.size()});
        return children.stream();
    }

    public String getContainedBy(String txId, FedoraId resource) {
        List parentID;
        String resourceID = resource.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceID);
        if (txId != null) {
            parameterSource.addValue("transactionId", (Object)txId);
            parentID = this.jdbcTemplate.queryForList(PARENT_EXISTS_IN_TRANSACTION, (SqlParameterSource)parameterSource, String.class);
        } else {
            parentID = this.jdbcTemplate.queryForList(PARENT_EXISTS, (SqlParameterSource)parameterSource, String.class);
        }
        return parentID.stream().findFirst().orElse(null);
    }

    public void addContainedBy(@Nonnull String txId, FedoraId parent, FedoraId child) {
        this.addContainedBy(txId, parent, child, Instant.now(), null);
    }

    public void addContainedBy(@Nonnull String txId, FedoraId parent, FedoraId child, Instant startTime, Instant endTime) {
        boolean purgedInTxn;
        String parentID = parent.getFullId();
        String childID = child.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        LOGGER.debug("Adding: parent: {}, child: {}, in txn: {}, start time {}, end time {}", new Object[]{parentID, childID, txId, this.formatInstant(startTime), this.formatInstant(endTime)});
        parameterSource.addValue(PARENT_COLUMN, (Object)parentID);
        parameterSource.addValue("child", (Object)childID);
        parameterSource.addValue("transactionId", (Object)txId);
        parameterSource.addValue("startTime", (Object)this.formatInstant(startTime));
        parameterSource.addValue("endTime", (Object)this.formatInstant(endTime));
        boolean bl = purgedInTxn = !this.jdbcTemplate.queryForList(IS_CHILD_PURGED_IN_TRANSACTION, (SqlParameterSource)parameterSource).isEmpty();
        if (purgedInTxn) {
            this.jdbcTemplate.update(UNDO_PURGE_CHILD_IN_TRANSACTION, (SqlParameterSource)parameterSource);
        }
        this.jdbcTemplate.update(INSERT_CHILD_IN_TRANSACTION, (SqlParameterSource)parameterSource);
    }

    public void removeContainedBy(@Nonnull String txId, FedoraId parent, FedoraId child) {
        boolean addedInTxn;
        String parentID = parent.getFullId();
        String childID = child.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue(PARENT_COLUMN, (Object)parentID);
        parameterSource.addValue("child", (Object)childID);
        parameterSource.addValue("transactionId", (Object)txId);
        parameterSource.addValue("endTime", (Object)this.formatInstant(Instant.now()));
        boolean bl = addedInTxn = !this.jdbcTemplate.queryForList(IS_CHILD_ADDED_IN_TRANSACTION, (SqlParameterSource)parameterSource).isEmpty();
        if (addedInTxn) {
            this.jdbcTemplate.update(UNDO_INSERT_CHILD_IN_TRANSACTION, (SqlParameterSource)parameterSource);
        } else {
            this.jdbcTemplate.update(DELETE_CHILD_IN_TRANSACTION, (SqlParameterSource)parameterSource);
        }
    }

    public void removeResource(@Nonnull String txId, FedoraId resource) {
        boolean addedInTxn;
        String resourceID = resource.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceID);
        parameterSource.addValue("transactionId", (Object)txId);
        boolean bl = addedInTxn = !this.jdbcTemplate.queryForList(IS_CHILD_ADDED_IN_TRANSACTION_NO_PARENT, (SqlParameterSource)parameterSource).isEmpty();
        if (addedInTxn) {
            this.jdbcTemplate.update(UNDO_INSERT_CHILD_IN_TRANSACTION_NO_PARENT, (SqlParameterSource)parameterSource);
        } else {
            String parent = this.getContainedBy(txId, resource);
            if (parent != null) {
                LOGGER.debug("Marking containment relationship between parent ({}) and child ({}) deleted", (Object)parent, (Object)resourceID);
                parameterSource.addValue(PARENT_COLUMN, (Object)parent);
                parameterSource.addValue("endTime", (Object)this.formatInstant(Instant.now()));
                this.jdbcTemplate.update(DELETE_CHILD_IN_TRANSACTION, (SqlParameterSource)parameterSource);
            }
        }
    }

    public void purgeResource(@Nonnull String txId, FedoraId resource) {
        boolean deletedInTxn;
        String resourceID = resource.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceID);
        parameterSource.addValue("transactionId", (Object)txId);
        String parent = this.getContainedByDeleted(txId, resource);
        boolean bl = deletedInTxn = !this.jdbcTemplate.queryForList(IS_CHILD_DELETED_IN_TRANSACTION_NO_PARENT, (SqlParameterSource)parameterSource).isEmpty();
        if (deletedInTxn) {
            this.jdbcTemplate.update(UNDO_DELETE_CHILD_IN_TRANSACTION_NO_PARENT, (SqlParameterSource)parameterSource);
        }
        if (parent != null) {
            LOGGER.debug("Removing containment relationship between parent ({}) and child ({})", (Object)parent, (Object)resourceID);
            parameterSource.addValue(PARENT_COLUMN, (Object)parent);
            this.jdbcTemplate.update(PURGE_CHILD_IN_TRANSACTION, (SqlParameterSource)parameterSource);
        }
    }

    private String getContainedByDeleted(String txId, FedoraId resource) {
        List parentID;
        String resourceID = resource.getFullId();
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceID);
        if (txId != null) {
            parameterSource.addValue("transactionId", (Object)txId);
            parentID = this.jdbcTemplate.queryForList(PARENT_EXISTS_DELETED_IN_TRANSACTION, (SqlParameterSource)parameterSource, String.class);
        } else {
            parentID = this.jdbcTemplate.queryForList(PARENT_EXISTS_DELETED, (SqlParameterSource)parameterSource, String.class);
        }
        return parentID.stream().findFirst().orElse(null);
    }

    @Transactional
    public void commitTransaction(String txId) {
        if (txId != null) {
            try {
                MapSqlParameterSource parameterSource = new MapSqlParameterSource();
                parameterSource.addValue("transactionId", (Object)txId);
                this.jdbcTemplate.update(COMMIT_PURGE_RECORDS, (SqlParameterSource)parameterSource);
                this.jdbcTemplate.update(this.COMMIT_DELETE_RECORDS.get(this.dbPlatform), (SqlParameterSource)parameterSource);
                this.jdbcTemplate.update(COMMIT_ADD_RECORDS, (SqlParameterSource)parameterSource);
                this.jdbcTemplate.update(DELETE_ENTIRE_TRANSACTION, (SqlParameterSource)parameterSource);
            }
            catch (Exception e) {
                LOGGER.warn("Unable to commit containment index transaction {}: {}", (Object)txId, (Object)e.getMessage());
                throw new RepositoryRuntimeException("Unable to commit containment index transaction", (Throwable)e);
            }
        }
    }

    public void rollbackTransaction(String txId) {
        if (txId != null) {
            MapSqlParameterSource parameterSource = new MapSqlParameterSource();
            parameterSource.addValue("transactionId", (Object)txId);
            this.jdbcTemplate.update(DELETE_ENTIRE_TRANSACTION, (SqlParameterSource)parameterSource);
        }
    }

    public boolean resourceExists(String txId, FedoraId fedoraId, boolean includeDeleted) {
        boolean exists;
        String resourceId = fedoraId.getBaseId();
        LOGGER.debug("Checking if {} exists in transaction {}", (Object)resourceId, (Object)txId);
        if (fedoraId.isRepositoryRoot()) {
            return true;
        }
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("child", (Object)resourceId);
        if (txId != null) {
            String queryToUse = includeDeleted ? RESOURCE_OR_TOMBSTONE_EXISTS_IN_TRANSACTION : RESOURCE_EXISTS_IN_TRANSACTION;
            parameterSource.addValue("transactionId", (Object)txId);
            exists = !this.jdbcTemplate.queryForList(queryToUse, (SqlParameterSource)parameterSource, String.class).isEmpty();
        } else {
            String queryToUse = includeDeleted ? RESOURCE_OR_TOMBSTONE_EXISTS : RESOURCE_EXISTS;
            exists = !this.jdbcTemplate.queryForList(queryToUse, (SqlParameterSource)parameterSource, String.class).isEmpty();
        }
        return exists;
    }

    public FedoraId getContainerIdByPath(String txId, FedoraId fedoraId, boolean checkDeleted) {
        if (fedoraId.isRepositoryRoot()) {
            return fedoraId;
        }
        String parent = this.getContainedBy(txId, fedoraId);
        if (parent != null) {
            return FedoraId.create((String[])new String[]{parent});
        }
        String fullId = fedoraId.getFullId();
        while (fullId.contains("/")) {
            fullId = fedoraId.getResourceId().substring(0, fullId.lastIndexOf("/"));
            if (fullId.equals("info:fedora")) {
                return FedoraId.getRepositoryRootId();
            }
            FedoraId testID = FedoraId.create((String[])new String[]{fullId});
            if (!this.resourceExists(txId, testID, checkDeleted)) continue;
            return testID;
        }
        return FedoraId.getRepositoryRootId();
    }

    @Transactional
    public void reset() {
        try {
            this.jdbcTemplate.update("TRUNCATE TABLE containment", Collections.emptyMap());
            this.jdbcTemplate.update("TRUNCATE TABLE containment_transactions", Collections.emptyMap());
        }
        catch (Exception e) {
            throw new RepositoryRuntimeException("Failed to truncate containment tables", (Throwable)e);
        }
    }

    public boolean hasResourcesStartingWith(String txId, FedoraId fedoraId) {
        boolean matchingIds;
        MapSqlParameterSource parameterSource = new MapSqlParameterSource();
        parameterSource.addValue("resourceId", (Object)(fedoraId.getFullId() + "/%"));
        if (txId != null) {
            parameterSource.addValue("transactionId", (Object)txId);
            matchingIds = !this.jdbcTemplate.queryForList(SELECT_ID_LIKE_IN_TRANSACTION, (SqlParameterSource)parameterSource, String.class).isEmpty();
        } else {
            matchingIds = !this.jdbcTemplate.queryForList(SELECT_ID_LIKE, (SqlParameterSource)parameterSource, String.class).isEmpty();
        }
        return matchingIds;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    private Timestamp formatInstant(Instant instant) {
        if (instant == null) {
            return null;
        }
        Timestamp timestamp = Timestamp.from(instant);
        timestamp.setNanos(0);
        return timestamp;
    }
}

