/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Timer;
import java.time.Instant;
import java.util.stream.Stream;
import org.fcrepo.common.metrics.MetricsHelper;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component(value="containmentIndex")
public class ContainmentIndexMetrics
implements ContainmentIndex {
    private static final String METRIC_NAME = "fcrepo.db";
    private static final String DB = "db";
    private static final String CONTAINMENT = "containment";
    private static final String OPERATION = "operation";
    private static final Timer getContainsTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContains"});
    private static final Timer getContainsDeletedTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContainsDeleted"});
    private static final Timer getContainsByTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContainsBy"});
    private static final Timer removeContainedByTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "removeContainedBy"});
    private static final Timer removeResourceTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "removeResource"});
    private static final Timer purgeResourceTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "purgeResource"});
    private static final Timer addContainedByTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "addContainedBy"});
    private static final Timer commitTransactionTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "commitTransaction"});
    private static final Timer rollbackTransactionTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "rollbackTransaction"});
    private static final Timer resourceExistsTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "resourceExists"});
    private static final Timer getContainerIdByPathTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "getContainerIdByPath"});
    private static final Timer resetTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "reset"});
    private static final Timer hasResourcesStartingWithTimer = Metrics.timer((String)"fcrepo.db", (String[])new String[]{"db", "containment", "operation", "hasResourcesStartingWith"});
    @Autowired
    @Qualifier(value="containmentIndexImpl")
    private ContainmentIndex containmentIndexImpl;

    public Stream<String> getContains(String txId, FedoraId fedoraId) {
        return (Stream)MetricsHelper.time((Timer)getContainsTimer, () -> this.containmentIndexImpl.getContains(txId, fedoraId));
    }

    public Stream<String> getContainsDeleted(String txId, FedoraId fedoraId) {
        return (Stream)MetricsHelper.time((Timer)getContainsDeletedTimer, () -> this.containmentIndexImpl.getContainsDeleted(txId, fedoraId));
    }

    public String getContainedBy(String txID, FedoraId resource) {
        return (String)MetricsHelper.time((Timer)getContainsByTimer, () -> this.containmentIndexImpl.getContainedBy(txID, resource));
    }

    public void removeContainedBy(String txID, FedoraId parent, FedoraId child) {
        removeContainedByTimer.record(() -> this.containmentIndexImpl.removeContainedBy(txID, parent, child));
    }

    public void removeResource(String txID, FedoraId resource) {
        removeResourceTimer.record(() -> this.containmentIndexImpl.removeResource(txID, resource));
    }

    public void purgeResource(String txID, FedoraId resource) {
        purgeResourceTimer.record(() -> this.containmentIndexImpl.purgeResource(txID, resource));
    }

    public void addContainedBy(String txID, FedoraId parent, FedoraId child) {
        addContainedByTimer.record(() -> this.containmentIndexImpl.addContainedBy(txID, parent, child));
    }

    public void addContainedBy(String txId, FedoraId parent, FedoraId child, Instant startTime, Instant endTime) {
        addContainedByTimer.record(() -> this.containmentIndexImpl.addContainedBy(txId, parent, child, startTime, endTime));
    }

    public void commitTransaction(String txId) {
        commitTransactionTimer.record(() -> this.containmentIndexImpl.commitTransaction(txId));
    }

    public void rollbackTransaction(String txId) {
        rollbackTransactionTimer.record(() -> this.containmentIndexImpl.rollbackTransaction(txId));
    }

    public boolean resourceExists(String txID, FedoraId fedoraId, boolean includeDeleted) {
        return (Boolean)MetricsHelper.time((Timer)resourceExistsTimer, () -> this.containmentIndexImpl.resourceExists(txID, fedoraId, includeDeleted));
    }

    public FedoraId getContainerIdByPath(String txID, FedoraId fedoraId, boolean checkDeleted) {
        return (FedoraId)MetricsHelper.time((Timer)getContainerIdByPathTimer, () -> this.containmentIndexImpl.getContainerIdByPath(txID, fedoraId, checkDeleted));
    }

    public void reset() {
        resetTimer.record(() -> this.containmentIndexImpl.reset());
    }

    public boolean hasResourcesStartingWith(String txId, FedoraId fedoraId) {
        return (Boolean)MetricsHelper.time((Timer)hasResourcesStartingWithTimer, () -> this.containmentIndexImpl.hasResourcesStartingWith(txId, fedoraId));
    }
}

