/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.Callable;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.TransactionClosedException;
import org.fcrepo.kernel.api.observer.EventAccumulator;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.fcrepo.kernel.impl.TransactionManagerImpl;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    public static final String TIMEOUT_SYSTEM_PROPERTY = "fcrepo.session.timeout";
    private static final Logger log = LoggerFactory.getLogger(TransactionImpl.class);
    private static final Duration DEFAULT_TIMEOUT = Duration.ofMinutes(3L);
    private final String id;
    private final TransactionManagerImpl txManager;
    private boolean shortLived = true;
    private Instant expiration;
    private boolean expired = false;
    private boolean rolledback = false;
    private boolean committed = false;
    private String baseUri;
    private String userAgent;

    protected TransactionImpl(String id, TransactionManagerImpl txManager) {
        if (id == null || id.isEmpty()) {
            throw new IllegalArgumentException("Transaction id should not be empty!");
        }
        this.id = id;
        this.txManager = txManager;
        this.expiration = Instant.now().plus(this.timeout());
    }

    public synchronized void commit() {
        this.failIfExpired();
        this.failIfRolledback();
        if (this.committed) {
            return;
        }
        try {
            log.debug("Committing transaction {}", (Object)this.id);
            this.getPersistentSession().commit();
            this.getContainmentIndex().commitTransaction(this.id);
            this.getReferenceService().commitTransaction(this.id);
            this.getMembershipService().commitTransaction(this.id);
            this.getEventAccumulator().emitEvents(this.id, this.baseUri, this.userAgent);
            this.committed = true;
        }
        catch (PersistentStorageException ex) {
            log.error("Failed to commit transaction: {}", (Object)this.id, (Object)ex);
            this.rollback();
            throw new RepositoryRuntimeException("Failed to commit transaction " + this.id, (Throwable)ex);
        }
    }

    public synchronized boolean isCommitted() {
        return this.committed;
    }

    public synchronized void rollback() {
        this.failIfCommitted();
        if (this.rolledback) {
            return;
        }
        log.info("Rolling back transaction {}", (Object)this.id);
        this.rolledback = true;
        this.execQuietly("Failed to rollback storage in transaction " + this.id, () -> {
            this.getPersistentSession().rollback();
            return null;
        });
        this.execQuietly("Failed to rollback index in transaction " + this.id, () -> {
            this.getContainmentIndex().rollbackTransaction(this.id);
            return null;
        });
        this.execQuietly("Failed to rollback reference index in transaction " + this.id, () -> {
            this.getReferenceService().rollbackTransaction(this.id);
            return null;
        });
        this.execQuietly("Failed to rollback membership index in transaction " + this.id, () -> {
            this.getMembershipService().rollbackTransaction(this.id);
            return null;
        });
        this.execQuietly("Failed to rollback events in transaction " + this.id, () -> {
            this.getEventAccumulator().clearEvents(this.id);
            return null;
        });
    }

    public synchronized boolean isRolledBack() {
        return this.rolledback;
    }

    public String getId() {
        return this.id;
    }

    public void setShortLived(boolean shortLived) {
        this.shortLived = shortLived;
    }

    public boolean isShortLived() {
        return this.shortLived;
    }

    public synchronized void expire() {
        this.expiration = Instant.now();
        this.expired = true;
    }

    public boolean hasExpired() {
        if (this.expired) {
            return true;
        }
        this.expired = this.expiration.isBefore(Instant.now());
        return this.expired;
    }

    public synchronized Instant updateExpiry(Duration amountToAdd) {
        this.failIfExpired();
        this.failIfCommitted();
        this.failIfRolledback();
        this.expiration = this.expiration.plus(amountToAdd);
        return this.expiration;
    }

    public Instant getExpires() {
        return this.expiration;
    }

    public void commitIfShortLived() {
        if (this.isShortLived()) {
            this.commit();
        }
    }

    public void refresh() {
        this.updateExpiry(this.timeout());
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    private Duration timeout() {
        String timeoutProperty = System.getProperty(TIMEOUT_SYSTEM_PROPERTY);
        if (timeoutProperty != null) {
            return Duration.ofMillis(Long.parseLong(timeoutProperty));
        }
        return DEFAULT_TIMEOUT;
    }

    private PersistentStorageSession getPersistentSession() {
        return this.txManager.getPersistentStorageSessionManager().getSession(this.id);
    }

    private void failIfExpired() {
        if (this.hasExpired()) {
            throw new TransactionClosedException("Transaction with transactionId: " + this.id + " expired!");
        }
    }

    private void failIfCommitted() {
        if (this.committed) {
            throw new TransactionClosedException("Transaction with transactionId: " + this.id + " is already committed!");
        }
    }

    private void failIfRolledback() {
        if (this.rolledback) {
            throw new TransactionClosedException("Transaction with transactionId: " + this.id + " is already rolledback!");
        }
    }

    private void execQuietly(String failureMessage, Callable<Void> callable) {
        try {
            callable.call();
        }
        catch (Exception e) {
            log.error(failureMessage, (Throwable)e);
        }
    }

    private ContainmentIndex getContainmentIndex() {
        return this.txManager.getContainmentIndex();
    }

    private EventAccumulator getEventAccumulator() {
        return this.txManager.getEventAccumulator();
    }

    private ReferenceService getReferenceService() {
        return this.txManager.getReferenceService();
    }

    private MembershipService getMembershipService() {
        return this.txManager.getMembershipService();
    }
}

