/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl;

import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionManager;
import org.fcrepo.kernel.api.exception.TransactionClosedException;
import org.fcrepo.kernel.api.exception.TransactionNotFoundException;
import org.fcrepo.kernel.api.observer.EventAccumulator;
import org.fcrepo.kernel.api.services.MembershipService;
import org.fcrepo.kernel.api.services.ReferenceService;
import org.fcrepo.kernel.impl.TransactionImpl;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
public class TransactionManagerImpl
implements TransactionManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransactionManagerImpl.class);
    private final Map<String, Transaction> transactions = new ConcurrentHashMap<String, Transaction>();
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;
    @Inject
    private PersistentStorageSessionManager pSessionManager;
    @Inject
    private EventAccumulator eventAccumulator;
    @Autowired
    @Qualifier(value="referenceService")
    private ReferenceService referenceService;
    @Inject
    private MembershipService membershipService;

    TransactionManagerImpl() {
    }

    @Scheduled(fixedDelayString="#{fedoraPropsConfig.sessionTimeout}")
    public void cleanupClosedTransactions() {
        LOGGER.trace("Cleaning up expired transactions");
        Iterator<Map.Entry<String, Transaction>> txIt = this.transactions.entrySet().iterator();
        while (txIt.hasNext()) {
            Map.Entry<String, Transaction> txEntry = txIt.next();
            Transaction tx = txEntry.getValue();
            if (tx.isCommitted() || tx.isRolledBack()) {
                if (tx.hasExpired()) {
                    txIt.remove();
                }
            } else if (tx.hasExpired()) {
                LOGGER.debug("Rolling back expired transaction {}", (Object)tx.getId());
                try {
                    tx.rollback();
                }
                catch (RuntimeException e) {
                    LOGGER.error("Failed to rollback expired transaction {}", (Object)tx.getId(), (Object)e);
                }
            }
            if (!tx.hasExpired()) continue;
            this.pSessionManager.removeSession(tx.getId());
        }
    }

    public synchronized Transaction create() {
        String txId = UUID.randomUUID().toString();
        while (this.transactions.containsKey(txId)) {
            txId = UUID.randomUUID().toString();
        }
        TransactionImpl tx = new TransactionImpl(txId, this);
        this.transactions.put(txId, tx);
        return tx;
    }

    public Transaction get(String transactionId) {
        if (this.transactions.containsKey(transactionId)) {
            Transaction transaction = this.transactions.get(transactionId);
            if (transaction.hasExpired()) {
                transaction.rollback();
                throw new TransactionClosedException("Transaction with transactionId: " + transactionId + " expired at " + transaction.getExpires() + "!");
            }
            if (transaction.isCommitted()) {
                throw new TransactionClosedException("Transaction with transactionId: " + transactionId + " has already been committed.");
            }
            if (transaction.isRolledBack()) {
                throw new TransactionClosedException("Transaction with transactionId: " + transactionId + " has already been rolled back.");
            }
            return transaction;
        }
        throw new TransactionNotFoundException("No Transaction found with transactionId: " + transactionId);
    }

    protected PersistentStorageSessionManager getPersistentStorageSessionManager() {
        return this.pSessionManager;
    }

    protected ContainmentIndex getContainmentIndex() {
        return this.containmentIndex;
    }

    protected EventAccumulator getEventAccumulator() {
        return this.eventAccumulator;
    }

    protected ReferenceService getReferenceService() {
        return this.referenceService;
    }

    protected MembershipService getMembershipService() {
        return this.membershipService;
    }
}

