/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.models;

import java.lang.reflect.Constructor;
import java.time.Instant;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionUtils;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.exception.ResourceTypeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.impl.models.BinaryImpl;
import org.fcrepo.kernel.impl.models.ContainerImpl;
import org.fcrepo.kernel.impl.models.FedoraResourceImpl;
import org.fcrepo.kernel.impl.models.NonRdfSourceDescriptionImpl;
import org.fcrepo.kernel.impl.models.TombstoneImpl;
import org.fcrepo.kernel.impl.models.WebacAclImpl;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ResourceFactoryImpl
implements ResourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceFactoryImpl.class);
    @Inject
    private PersistentStorageSessionManager persistentStorageSessionManager;
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;

    public FedoraResource getResource(FedoraId fedoraID) throws PathNotFoundException {
        return this.instantiateResource(null, fedoraID);
    }

    public FedoraResource getResource(Transaction transaction, FedoraId fedoraID) throws PathNotFoundException {
        return this.getResource(TransactionUtils.openTxId((Transaction)transaction), fedoraID);
    }

    public FedoraResource getResource(String transactionId, FedoraId fedoraID) throws PathNotFoundException {
        return this.instantiateResource(transactionId, fedoraID);
    }

    public <T extends FedoraResource> T getResource(FedoraId identifier, Class<T> clazz) throws PathNotFoundException {
        return (T)((FedoraResource)clazz.cast(this.getResource((Transaction)null, identifier)));
    }

    public <T extends FedoraResource> T getResource(Transaction transaction, FedoraId identifier, Class<T> clazz) throws PathNotFoundException {
        return (T)((FedoraResource)clazz.cast(this.getResource(transaction, identifier)));
    }

    public FedoraResource getContainer(String transactionId, FedoraId resourceId) {
        String containerId = this.containmentIndex.getContainedBy(transactionId, resourceId);
        if (containerId == null) {
            return null;
        }
        try {
            return this.getResource(transactionId, FedoraId.create((String[])new String[]{containerId}));
        }
        catch (PathNotFoundException exc) {
            return null;
        }
    }

    private Class<? extends FedoraResourceImpl> getClassForTypes(ResourceHeaders headers) {
        String ixModel = headers.getInteractionModel();
        if (RdfLexicon.BASIC_CONTAINER.getURI().equals(ixModel) || RdfLexicon.INDIRECT_CONTAINER.getURI().equals(ixModel) || RdfLexicon.DIRECT_CONTAINER.getURI().equals(ixModel)) {
            return ContainerImpl.class;
        }
        if (RdfLexicon.NON_RDF_SOURCE.getURI().equals(ixModel)) {
            return BinaryImpl.class;
        }
        if ("http://fedora.info/definitions/v4/repository#NonRdfSourceDescription".equals(ixModel)) {
            return NonRdfSourceDescriptionImpl.class;
        }
        if ("http://fedora.info/definitions/v4/webac#Acl".equals(ixModel)) {
            return WebacAclImpl.class;
        }
        throw new ResourceTypeException("Could not identify the resource type for interaction model " + ixModel);
    }

    private FedoraResource instantiateResource(String transactionId, FedoraId identifier) throws PathNotFoundException {
        try {
            PersistentStorageSession psSession = this.getSession(transactionId);
            Instant versionDateTime = identifier.isMemento() ? identifier.getMementoInstant() : null;
            ResourceHeaders headers = psSession.getHeaders(identifier, versionDateTime);
            Class<? extends FedoraResourceImpl> createClass = this.getClassForTypes(headers);
            Constructor<? extends FedoraResourceImpl> constructor = createClass.getConstructor(FedoraId.class, String.class, PersistentStorageSessionManager.class, ResourceFactory.class);
            FedoraId instantiationId = identifier.isTimemap() ? FedoraId.create((String[])new String[]{identifier.getResourceId()}) : identifier;
            FedoraResourceImpl rescImpl = constructor.newInstance(instantiationId, transactionId, this.persistentStorageSessionManager, this);
            this.populateResourceHeaders(rescImpl, headers, versionDateTime);
            if (headers.isDeleted()) {
                FedoraId rootId = FedoraId.create((String[])new String[]{identifier.getBaseId()});
                TombstoneImpl tombstone = new TombstoneImpl(rootId, transactionId, this.persistentStorageSessionManager, this, rescImpl);
                tombstone.setLastModifiedDate(headers.getLastModifiedDate());
                return tombstone;
            }
            if (identifier.isTimemap()) {
                return rescImpl.getTimeMap();
            }
            return rescImpl;
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RepositoryRuntimeException("Unable to construct object", (Throwable)e);
        }
        catch (PersistentItemNotFoundException e) {
            throw new PathNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (PersistentStorageException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private void populateResourceHeaders(FedoraResourceImpl resc, ResourceHeaders headers, Instant version) {
        resc.setCreatedBy(headers.getCreatedBy());
        resc.setCreatedDate(headers.getCreatedDate());
        resc.setLastModifiedBy(headers.getLastModifiedBy());
        resc.setLastModifiedDate(headers.getLastModifiedDate());
        resc.setParentId(headers.getParent());
        resc.setEtag(headers.getStateToken());
        resc.setStateToken(headers.getStateToken());
        resc.setIsArchivalGroup(headers.isArchivalGroup());
        resc.setInteractionModel(headers.getInteractionModel());
        if (version != null) {
            resc.setIsMemento(true);
            resc.setMementoDatetime(version);
        }
        if (resc instanceof Binary) {
            BinaryImpl binary = (BinaryImpl)resc;
            binary.setContentSize(headers.getContentSize());
            binary.setExternalHandling(headers.getExternalHandling());
            binary.setExternalUrl(headers.getExternalUrl());
            binary.setDigests(headers.getDigests());
            binary.setFilename(headers.getFilename());
            binary.setMimeType(headers.getMimeType());
        }
    }

    private PersistentStorageSession getSession(String transactionId) {
        PersistentStorageSession session = transactionId == null ? this.persistentStorageSessionManager.getReadOnlySession() : this.persistentStorageSessionManager.getSession(transactionId);
        return session;
    }

    public Stream<FedoraResource> getChildren(String transactionId, FedoraId resourceId) {
        return this.containmentIndex.getContains(transactionId, resourceId).map(childId -> {
            try {
                return this.getResource(transactionId, FedoraId.create((String[])new String[]{childId}));
            }
            catch (PathNotFoundException e) {
                throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
            }
        });
    }
}

