/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import com.google.common.base.Preconditions;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.sql.DataSource;
import javax.transaction.Transactional;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.fcrepo.common.db.DbPlatform;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.impl.services.MembershipServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.datasource.init.DatabasePopulator;
import org.springframework.jdbc.datasource.init.DatabasePopulatorUtils;
import org.springframework.jdbc.datasource.init.ResourceDatabasePopulator;
import org.springframework.stereotype.Component;

@Component
public class MembershipIndexManager {
    private static final Logger log = LoggerFactory.getLogger(MembershipIndexManager.class);
    private static final Timestamp NO_END_TIMESTAMP = Timestamp.from(MembershipServiceImpl.NO_END_INSTANT);
    private static final Timestamp NO_START_TIMESTAMP = Timestamp.from(Instant.parse("1000-01-01T00:00:00.000Z"));
    private static final String ADD_OPERATION = "add";
    private static final String DELETE_OPERATION = "delete";
    private static final String FORCE_FLAG = "force";
    private static final String TX_ID_PARAM = "txId";
    private static final String SUBJECT_ID_PARAM = "subjectId";
    private static final String NO_END_TIME_PARAM = "noEndTime";
    private static final String ADD_OP_PARAM = "addOp";
    private static final String DELETE_OP_PARAM = "deleteOp";
    private static final String MEMENTO_TIME_PARAM = "mementoTime";
    private static final String PROPERTY_PARAM = "property";
    private static final String TARGET_ID_PARAM = "targetId";
    private static final String SOURCE_ID_PARAM = "sourceId";
    private static final String START_TIME_PARAM = "startTime";
    private static final String END_TIME_PARAM = "endTime";
    private static final String OPERATION_PARAM = "operation";
    private static final String FORCE_PARAM = "forceFlag";
    private static final String OBJECT_ID_PARAM = "objectId";
    private static final String SELECT_ALL_MEMBERSHIP = "SELECT * FROM membership";
    private static final String SELECT_ALL_OPERATIONS = "SELECT * FROM membership_tx_operations";
    private static final String SELECT_MEMBERSHIP_IN_TX = "SELECT m.property, m.object_id FROM membership m WHERE subject_id = :subjectId AND end_time = :noEndTime AND NOT EXISTS ( SELECT 1 FROM membership_tx_operations mto WHERE mto.subject_id = :subjectId AND mto.source_id = m.source_id AND mto.object_id = m.object_id AND mto.tx_id = :txId AND mto.operation = :deleteOp) UNION SELECT property, object_id FROM membership_tx_operations WHERE subject_id = :subjectId AND tx_id = :txId AND end_time = :noEndTime AND operation = :addOp";
    private static final String SELECT_MEMBERSHIP_MEMENTO_IN_TX = "SELECT property, object_id FROM membership m WHERE m.subject_id = :subjectId AND m.start_time <= :mementoTime AND m.end_time > :mementoTime AND NOT EXISTS ( SELECT 1 FROM membership_tx_operations mto WHERE mto.subject_id = :subjectId AND mto.source_id = m.source_id AND mto.property = m.property AND mto.object_id = m.object_id AND mto.end_time <= :mementoTime AND mto.tx_id = :txId AND mto.operation = :deleteOp) UNION SELECT property, object_id FROM membership_tx_operations WHERE subject_id = :subjectId AND tx_id = :txId AND start_time <= :mementoTime AND end_time > :mementoTime AND operation = :addOp";
    private static final String INSERT_MEMBERSHIP_IN_TX = "INSERT INTO membership_tx_operations (subject_id, property, object_id, source_id, start_time, end_time, tx_id, operation) VALUES (:subjectId, :property, :targetId, :sourceId, :startTime, :endTime, :txId, :operation)";
    private static final String END_EXISTING_MEMBERSHIP = "INSERT INTO membership_tx_operations (subject_id, property, object_id, source_id, start_time, end_time, tx_id, operation) SELECT m.subject_id, m.property, m.object_id, m.source_id, m.start_time, :endTime, :txId, :deleteOp FROM membership m WHERE m.source_id = :sourceId AND m.end_time = :noEndTime AND m.subject_id = :subjectId AND m.property = :property AND m.object_id = :objectId";
    private static final String CLEAR_ENTRY_IN_TX = "DELETE FROM membership_tx_operations WHERE source_id = :sourceId AND tx_id = :txId AND subject_id = :subjectId AND property = :property AND object_id = :objectId AND operation = :operation AND force_flag IS NULL";
    private static final String CLEAR_ALL_ADDED_FOR_SOURCE_IN_TX = "DELETE FROM membership_tx_operations WHERE source_id = :sourceId AND tx_id = :txId AND operation = :addOp";
    private static final String END_EXISTING_FOR_SOURCE = "INSERT INTO membership_tx_operations (subject_id, property, object_id, source_id, start_time, end_time, tx_id, operation) SELECT subject_id, property, object_id, source_id, start_time, :endTime, :txId, :deleteOp FROM membership m WHERE source_id = :sourceId AND end_time = :noEndTime AND NOT EXISTS ( SELECT TRUE FROM membership_tx_operations mtx WHERE mtx.subject_id = m.subject_id AND mtx.property = m.property AND mtx.object_id = m.object_id AND mtx.source_id = m.source_id AND mtx.operation = :deleteOp)";
    private static final String DELETE_EXISTING_FOR_SOURCE_AFTER = "INSERT INTO membership_tx_operations (subject_id, property, object_id, source_id, start_time, end_time, tx_id, operation, force_flag) SELECT subject_id, property, object_id, source_id, start_time, end_time, :txId, :deleteOp, :forceFlag FROM membership m WHERE m.source_id = :sourceId AND (m.start_time >= :startTime OR m.end_time >= :startTime)";
    private static final String PURGE_ALL_REFERENCES_MEMBERSHIP = "DELETE from membership where source_id = :targetId OR subject_id = :targetId OR object_id = :targetId";
    private static final String PURGE_ALL_REFERENCES_TRANSACTION = "DELETE from membership_tx_operations WHERE tx_id = :txId AND (source_id = :targetId OR subject_id = :targetId OR object_id = :targetId)";
    private static final String COMMIT_DELETES = "DELETE from membership WHERE EXISTS ( SELECT TRUE FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND mto.force_flag = :forceFlag AND membership.source_id = mto.source_id AND membership.subject_id = mto.subject_id AND membership.property = mto.property AND membership.object_id = mto.object_id )";
    private static final String COMMIT_ENDS_H2 = "UPDATE membership m SET end_time = ( SELECT mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND mto.operation = :deleteOp ) WHERE EXISTS (SELECT TRUE FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id )";
    private static final String COMMIT_ENDS_POSTGRES = "UPDATE membership SET end_time = mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND membership.source_id = mto.source_id AND membership.subject_id = mto.subject_id AND membership.property = mto.property AND membership.object_id = mto.object_id";
    private static final String COMMIT_ENDS_MYSQL = "UPDATE membership m INNER JOIN membership_tx_operations mto ON m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id SET m.end_time = mto.end_time WHERE mto.tx_id = :txId AND mto.operation = :deleteOp";
    private static final Map<DbPlatform, String> COMMIT_ENDS_MAP = Map.of(DbPlatform.MYSQL, "UPDATE membership m INNER JOIN membership_tx_operations mto ON m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id SET m.end_time = mto.end_time WHERE mto.tx_id = :txId AND mto.operation = :deleteOp", DbPlatform.MARIADB, "UPDATE membership m INNER JOIN membership_tx_operations mto ON m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id SET m.end_time = mto.end_time WHERE mto.tx_id = :txId AND mto.operation = :deleteOp", DbPlatform.POSTGRESQL, "UPDATE membership SET end_time = mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND membership.source_id = mto.source_id AND membership.subject_id = mto.subject_id AND membership.property = mto.property AND membership.object_id = mto.object_id", DbPlatform.H2, "UPDATE membership m SET end_time = ( SELECT mto.end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND mto.operation = :deleteOp ) WHERE EXISTS (SELECT TRUE FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :deleteOp AND m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id )");
    private static final String COMMIT_ADDS = "INSERT INTO membership (subject_id, property, object_id, source_id, start_time, end_time) SELECT subject_id, property, object_id, source_id, start_time, end_time FROM membership_tx_operations mto WHERE mto.tx_id = :txId AND mto.operation = :addOp AND NOT EXISTS ( SELECT TRUE FROM membership m WHERE m.source_id = mto.source_id AND m.subject_id = mto.subject_id AND m.property = mto.property AND m.object_id = mto.object_id AND m.start_time = mto.start_time AND m.end_time = mto.end_time )";
    private static final String DELETE_TRANSACTION = "DELETE FROM membership_tx_operations WHERE tx_id = :txId";
    private static final String TRUNCATE_MEMBERSHIP = "TRUNCATE TABLE membership";
    private static final String TRUNCATE_MEMBERSHIP_TX = "TRUNCATE TABLE membership_tx_operations";
    @Inject
    private DataSource dataSource;
    private NamedParameterJdbcTemplate jdbcTemplate;
    private DbPlatform dbPlatform;
    private static final Map<DbPlatform, String> DDL_MAP = Map.of(DbPlatform.MYSQL, "sql/mysql-membership.sql", DbPlatform.H2, "sql/default-membership.sql", DbPlatform.POSTGRESQL, "sql/default-membership.sql", DbPlatform.MARIADB, "sql/mariadb-membership.sql");

    @PostConstruct
    public void setUp() {
        this.jdbcTemplate = new NamedParameterJdbcTemplate(this.getDataSource());
        this.dbPlatform = DbPlatform.fromDataSource((DataSource)this.dataSource);
        Preconditions.checkArgument((boolean)DDL_MAP.containsKey(this.dbPlatform), (String)"Missing DDL mapping for %s", (Object)this.dbPlatform);
        String ddl = DDL_MAP.get(this.dbPlatform);
        log.debug("Applying ddl: {}", (Object)ddl);
        DatabasePopulatorUtils.execute((DatabasePopulator)new ResourceDatabasePopulator(new Resource[]{new DefaultResourceLoader().getResource("classpath:" + ddl)}), (DataSource)this.dataSource);
    }

    @Transactional
    public void endMembership(String txId, FedoraId sourceId, Triple membership, Instant endTime) {
        Map<String, String> parameterSource = Map.of(TX_ID_PARAM, txId, SOURCE_ID_PARAM, sourceId.getFullId(), SUBJECT_ID_PARAM, membership.getSubject().getURI(), PROPERTY_PARAM, membership.getPredicate().getURI(), OBJECT_ID_PARAM, membership.getObject().getURI(), OPERATION_PARAM, ADD_OPERATION);
        int affected = this.jdbcTemplate.update(CLEAR_ENTRY_IN_TX, parameterSource);
        if (affected == 0) {
            Map<String, String> parameterSource2 = Map.of(TX_ID_PARAM, txId, SOURCE_ID_PARAM, sourceId.getFullId(), SUBJECT_ID_PARAM, membership.getSubject().getURI(), PROPERTY_PARAM, membership.getPredicate().getURI(), OBJECT_ID_PARAM, membership.getObject().getURI(), END_TIME_PARAM, this.formatInstant(endTime), NO_END_TIME_PARAM, NO_END_TIMESTAMP, DELETE_OP_PARAM, DELETE_OPERATION);
            this.jdbcTemplate.update(END_EXISTING_MEMBERSHIP, parameterSource2);
        }
    }

    @Transactional
    public void endMembershipForSource(String txId, FedoraId sourceId, Instant endTime) {
        Map<String, String> parameterSource = Map.of(TX_ID_PARAM, txId, SOURCE_ID_PARAM, sourceId.getFullId(), ADD_OP_PARAM, ADD_OPERATION);
        this.jdbcTemplate.update(CLEAR_ALL_ADDED_FOR_SOURCE_IN_TX, parameterSource);
        Map<String, String> parameterSource2 = Map.of(TX_ID_PARAM, txId, SOURCE_ID_PARAM, sourceId.getFullId(), END_TIME_PARAM, this.formatInstant(endTime), NO_END_TIME_PARAM, NO_END_TIMESTAMP, DELETE_OP_PARAM, DELETE_OPERATION);
        this.jdbcTemplate.update(END_EXISTING_FOR_SOURCE, parameterSource2);
    }

    @Transactional
    public void deleteMembershipForSourceAfter(String txId, FedoraId sourceId, Instant afterTime) {
        Map<String, String> parameterSource = Map.of(TX_ID_PARAM, txId, SOURCE_ID_PARAM, sourceId.getFullId(), ADD_OP_PARAM, ADD_OPERATION);
        this.jdbcTemplate.update(CLEAR_ALL_ADDED_FOR_SOURCE_IN_TX, parameterSource);
        Timestamp afterTimestamp = afterTime == null ? NO_START_TIMESTAMP : this.formatInstant(afterTime);
        Map<String, String> parameterSource2 = Map.of(TX_ID_PARAM, txId, SOURCE_ID_PARAM, sourceId.getFullId(), START_TIME_PARAM, afterTimestamp, FORCE_PARAM, FORCE_FLAG, DELETE_OP_PARAM, DELETE_OPERATION);
        this.jdbcTemplate.update(DELETE_EXISTING_FOR_SOURCE_AFTER, parameterSource2);
    }

    @Transactional
    public void deleteMembershipReferences(String txId, FedoraId targetId) {
        Map<String, String> parameterSource = Map.of(TARGET_ID_PARAM, targetId.getFullId(), TX_ID_PARAM, txId);
        this.jdbcTemplate.update(PURGE_ALL_REFERENCES_TRANSACTION, parameterSource);
        this.jdbcTemplate.update(PURGE_ALL_REFERENCES_MEMBERSHIP, parameterSource);
    }

    @Transactional
    public void addMembership(String txId, FedoraId sourceId, Triple membership, Instant startTime) {
        Map<String, String> parametersDelete = Map.of(TX_ID_PARAM, txId, SOURCE_ID_PARAM, sourceId.getFullId(), SUBJECT_ID_PARAM, membership.getSubject().getURI(), PROPERTY_PARAM, membership.getPredicate().getURI(), OBJECT_ID_PARAM, membership.getObject().getURI(), OPERATION_PARAM, DELETE_OPERATION);
        this.jdbcTemplate.update(CLEAR_ENTRY_IN_TX, parametersDelete);
        this.addMembership(txId, sourceId, membership, startTime, null);
    }

    public void addMembership(String txId, FedoraId sourceId, Triple membership, Instant startTime, Instant endTime) {
        Timestamp endTimestamp = endTime == null ? NO_END_TIMESTAMP : this.formatInstant(endTime);
        Map<String, String> parameterSource = Map.of(SUBJECT_ID_PARAM, membership.getSubject().getURI(), PROPERTY_PARAM, membership.getPredicate().getURI(), TARGET_ID_PARAM, membership.getObject().getURI(), SOURCE_ID_PARAM, sourceId.getFullId(), START_TIME_PARAM, this.formatInstant(startTime), END_TIME_PARAM, endTimestamp, TX_ID_PARAM, txId, OPERATION_PARAM, ADD_OPERATION);
        this.jdbcTemplate.update(INSERT_MEMBERSHIP_IN_TX, parameterSource);
    }

    public Stream<Triple> getMembership(String txId, FedoraId subjectId) {
        Node subjectNode = NodeFactory.createURI((String)subjectId.getBaseId());
        RowMapper membershipMapper = (rs, rowNum) -> Triple.create((Node)subjectNode, (Node)NodeFactory.createURI((String)rs.getString(PROPERTY_PARAM)), (Node)NodeFactory.createURI((String)rs.getString("object_id")));
        List membership = null;
        if (subjectId.isMemento()) {
            Map<String, String> parameterSource = Map.of(SUBJECT_ID_PARAM, subjectId.getBaseId(), MEMENTO_TIME_PARAM, this.formatInstant(subjectId.getMementoInstant()), TX_ID_PARAM, txId, ADD_OP_PARAM, ADD_OPERATION, DELETE_OP_PARAM, DELETE_OPERATION);
            membership = this.jdbcTemplate.query(SELECT_MEMBERSHIP_MEMENTO_IN_TX, parameterSource, membershipMapper);
        } else {
            Map<String, String> parameterSource = Map.of(SUBJECT_ID_PARAM, subjectId.getFullId(), NO_END_TIME_PARAM, NO_END_TIMESTAMP, TX_ID_PARAM, txId, ADD_OP_PARAM, ADD_OPERATION, DELETE_OP_PARAM, DELETE_OPERATION);
            membership = this.jdbcTemplate.query(SELECT_MEMBERSHIP_IN_TX, parameterSource, membershipMapper);
        }
        return membership.stream();
    }

    @Transactional
    public void commitTransaction(String txId) {
        Map<String, String> parameterSource = Map.of(TX_ID_PARAM, txId, ADD_OP_PARAM, ADD_OPERATION, DELETE_OP_PARAM, DELETE_OPERATION, FORCE_PARAM, FORCE_FLAG);
        this.jdbcTemplate.update(COMMIT_DELETES, parameterSource);
        int ends = this.jdbcTemplate.update(COMMIT_ENDS_MAP.get(this.dbPlatform), parameterSource);
        int adds = this.jdbcTemplate.update(COMMIT_ADDS, parameterSource);
        int cleaned = this.jdbcTemplate.update(DELETE_TRANSACTION, parameterSource);
        log.debug("Completed commit, {} ended, {} adds, {} operations", new Object[]{ends, adds, cleaned});
    }

    public void deleteTransaction(String txId) {
        Map<String, String> parameterSource = Map.of(TX_ID_PARAM, txId);
        this.jdbcTemplate.update(DELETE_TRANSACTION, parameterSource);
    }

    private Timestamp formatInstant(Instant instant) {
        Timestamp timestamp = Timestamp.from(instant);
        timestamp.setNanos(0);
        return timestamp;
    }

    @Transactional
    public void clearIndex() {
        this.jdbcTemplate.update(TRUNCATE_MEMBERSHIP, Map.of());
        this.jdbcTemplate.update(TRUNCATE_MEMBERSHIP_TX, Map.of());
    }

    public void logMembership() {
        log.info("source_id, subject_id, property, object_id, start_time, end_time");
        this.jdbcTemplate.query(SELECT_ALL_MEMBERSHIP, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                log.info("{}, {}, {}, {}, {}, {}", new Object[]{rs.getString("source_id"), rs.getString("subject_id"), rs.getString(MembershipIndexManager.PROPERTY_PARAM), rs.getString("object_id"), rs.getTimestamp("start_time"), rs.getTimestamp("end_time")});
            }
        });
    }

    public void logOperations() {
        log.info("source_id, subject_id, property, object_id, start_time, end_time, tx_id, operation, force_flag");
        this.jdbcTemplate.query(SELECT_ALL_OPERATIONS, new RowCallbackHandler(){

            public void processRow(ResultSet rs) throws SQLException {
                log.info("{}, {}, {}, {}, {}, {}, {}, {}, {}", new Object[]{rs.getString("source_id"), rs.getString("subject_id"), rs.getString(MembershipIndexManager.PROPERTY_PARAM), rs.getString("object_id"), rs.getTimestamp("start_time"), rs.getTimestamp("end_time"), rs.getString("tx_id"), rs.getString(MembershipIndexManager.OPERATION_PARAM), rs.getString("force_flag")});
            }
        });
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }
}

