/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.inject.Inject;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.operations.RdfSourceOperation;
import org.fcrepo.kernel.api.operations.RdfSourceOperationFactory;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.api.services.ReplacePropertiesService;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.springframework.stereotype.Component;

@Component
public class ReplacePropertiesServiceImpl
extends AbstractService
implements ReplacePropertiesService {
    @Inject
    private PersistentStorageSessionManager psManager;
    @Inject
    private RdfSourceOperationFactory factory;

    public void perform(String txId, String userPrincipal, FedoraId fedoraId, Model inputModel) throws MalformedRdfException {
        try {
            PersistentStorageSession pSession = this.psManager.getSession(txId);
            ResourceHeaders headers = pSession.getHeaders(fedoraId, null);
            String interactionModel = headers.getInteractionModel();
            this.ensureValidDirectContainer(fedoraId, interactionModel, inputModel);
            this.ensureValidACLAuthorization(inputModel);
            RdfSourceOperation updateOp = this.factory.updateBuilder(fedoraId).relaxedProperties(inputModel).userPrincipal(userPrincipal).triples(DefaultRdfStream.fromModel((Node)inputModel.createResource(fedoraId.getFullId()).asNode(), (Model)inputModel)).build();
            pSession.persist((ResourceOperation)updateOp);
            this.updateReferences(txId, fedoraId, userPrincipal, inputModel);
            this.membershipService.resourceModified(txId, fedoraId);
            this.recordEvent(txId, fedoraId, (ResourceOperation)updateOp);
        }
        catch (PersistentStorageException ex) {
            throw new RepositoryRuntimeException(String.format("failed to replace resource %s", fedoraId), (Throwable)ex);
        }
    }
}

