/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import javax.inject.Inject;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.update.UpdateAction;
import org.apache.jena.update.UpdateFactory;
import org.apache.jena.update.UpdateRequest;
import org.fcrepo.kernel.api.RdfCollectors;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.exception.AccessDeniedException;
import org.fcrepo.kernel.api.exception.ItemNotFoundException;
import org.fcrepo.kernel.api.exception.MalformedRdfException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.services.ReplacePropertiesService;
import org.fcrepo.kernel.api.services.UpdatePropertiesService;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.springframework.stereotype.Component;

@Component
public class UpdatePropertiesServiceImpl
extends AbstractService
implements UpdatePropertiesService {
    @Inject
    private ReplacePropertiesService replacePropertiesService;
    @Inject
    private PersistentStorageSessionManager persistentStorageSessionManager;

    public void updateProperties(String txId, String userPrincipal, FedoraId fedoraId, String sparqlUpdateStatement) throws MalformedRdfException, AccessDeniedException {
        try {
            PersistentStorageSession psession = this.persistentStorageSessionManager.getSession(txId);
            RdfStream triples = psession.getTriples(fedoraId, null);
            Model model = (Model)triples.collect(RdfCollectors.toModel());
            UpdateRequest request = UpdateFactory.create((String)sparqlUpdateStatement, (String)fedoraId.getFullId());
            UpdateAction.execute((UpdateRequest)request, (Model)model);
            this.replacePropertiesService.perform(txId, userPrincipal, fedoraId, model);
        }
        catch (PersistentItemNotFoundException ex) {
            throw new ItemNotFoundException(ex.getMessage(), (Throwable)ex);
        }
        catch (PersistentStorageException ex) {
            throw new RepositoryRuntimeException(ex.getMessage(), (Throwable)ex);
        }
    }
}

