/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserUtil.class);
    @VisibleForTesting
    public static final String USER_AGENT_BASE_URI_PROPERTY = "fcrepo.auth.webac.userAgent.baseUri";
    @VisibleForTesting
    public static final String DEFAULT_USER_AGENT_BASE_URI = "info:fedora/local-user#";

    private UserUtil() {
    }

    public static URI getUserURI(String sessionUserId) {
        String userId = (sessionUserId == null ? "anonymous" : sessionUserId).replaceAll("^<|>$", "");
        try {
            URI uri = URI.create(userId);
            if (uri.isAbsolute() || uri.isOpaque()) {
                return uri;
            }
            return UserUtil.buildDefaultURI(userId);
        }
        catch (IllegalArgumentException e) {
            return UserUtil.buildDefaultURI(userId);
        }
    }

    private static URI buildDefaultURI(String userId) {
        String userAgentBaseUri = System.getProperty(USER_AGENT_BASE_URI_PROPERTY);
        if (Strings.isNullOrEmpty((String)userAgentBaseUri)) {
            userAgentBaseUri = DEFAULT_USER_AGENT_BASE_URI;
        }
        String userAgentUri = userAgentBaseUri + userId;
        LOGGER.trace("Default URI is created for user {}: {}", (Object)userId, (Object)userAgentUri);
        return URI.create(userAgentUri);
    }
}

