/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.models;

import javax.inject.Inject;
import org.fcrepo.kernel.api.ContainmentIndex;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.TransactionUtils;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceHeaders;
import org.fcrepo.kernel.api.models.ResourceHelper;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.fcrepo.persistence.common.ResourceHeadersImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ResourceHelperImpl
implements ResourceHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResourceHeadersImpl.class);
    @Inject
    private PersistentStorageSessionManager persistentStorageSessionManager;
    @Autowired
    @Qualifier(value="containmentIndex")
    private ContainmentIndex containmentIndex;

    public boolean isGhostNode(Transaction transaction, FedoraId resourceId) {
        if (!this.doesResourceExist(transaction, resourceId, true)) {
            return this.containmentIndex.hasResourcesStartingWith(TransactionUtils.openTxId((Transaction)transaction), resourceId);
        }
        return false;
    }

    public boolean doesResourceExist(Transaction transaction, FedoraId fedoraId, boolean includeDeleted) {
        String transactionId = TransactionUtils.openTxId((Transaction)transaction);
        if (fedoraId.isRepositoryRoot()) {
            return true;
        }
        if (!fedoraId.isMemento() && !fedoraId.isAcl()) {
            return this.containmentIndex.resourceExists(transactionId, fedoraId, includeDeleted);
        }
        PersistentStorageSession psSession = this.getSession(transactionId);
        try {
            ResourceHeaders headers = psSession.getHeaders(fedoraId, fedoraId.getMementoInstant());
            return !headers.isDeleted();
        }
        catch (PersistentItemNotFoundException e) {
            return false;
        }
        catch (PersistentStorageException e) {
            throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
        }
    }

    private PersistentStorageSession getSession(String transactionId) {
        PersistentStorageSession session = transactionId == null ? this.persistentStorageSessionManager.getReadOnlySession() : this.persistentStorageSessionManager.getSession(transactionId);
        return session;
    }
}

