/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.models;

import java.net.URI;
import java.time.Instant;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.impl.StatementImpl;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.exception.ItemNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.TimeMap;
import org.fcrepo.kernel.api.rdf.DefaultRdfStream;
import org.fcrepo.kernel.impl.models.FedoraResourceImpl;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentItemNotFoundException;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;

public class TimeMapImpl
extends FedoraResourceImpl
implements TimeMap {
    private static final List<URI> HEADER_AND_RDF_TYPES = List.of(URI.create(RdfLexicon.RESOURCE.getURI()), URI.create(RdfLexicon.CONTAINER.getURI()), URI.create(RdfLexicon.RDF_SOURCE.getURI()));
    private static final List<URI> HEADER_ONLY_TYPES = Stream.concat(HEADER_AND_RDF_TYPES.stream(), List.of(URI.create(RdfLexicon.VERSIONING_TIMEMAP.getURI())).stream()).collect(Collectors.toList());
    private final FedoraResource originalResource;
    private List<Instant> versions;

    protected TimeMapImpl(FedoraResource originalResource, String txId, PersistentStorageSessionManager pSessionManager, ResourceFactory resourceFactory) {
        super(originalResource.getFedoraId().asTimemap(), txId, pSessionManager, resourceFactory);
        this.originalResource = originalResource;
        this.setCreatedBy(originalResource.getCreatedBy());
        this.setCreatedDate(originalResource.getCreatedDate());
        this.setLastModifiedBy(originalResource.getLastModifiedBy());
        this.setLastModifiedDate(originalResource.getLastModifiedDate());
        this.setParentId(originalResource.getFedoraId().asResourceId());
        this.setEtag(originalResource.getEtagValue());
        this.setStateToken(originalResource.getStateToken());
    }

    @Override
    public RdfStream getTriples() {
        Resource timeMapResource = this.asResource(this);
        Model model = ModelFactory.createDefaultModel();
        model.add((Statement)new StatementImpl(timeMapResource, RdfLexicon.MEMENTO_ORIGINAL_RESOURCE, (RDFNode)this.asResource(this.getOriginalResource())));
        this.getChildren().map(this::asResource).forEach(child -> model.add((Statement)new StatementImpl(timeMapResource, RdfLexicon.CONTAINS, (RDFNode)child)));
        return DefaultRdfStream.fromModel((Node)timeMapResource.asNode(), (Model)model);
    }

    @Override
    public List<URI> getSystemTypes(boolean forRdf) {
        if (forRdf) {
            return HEADER_AND_RDF_TYPES;
        }
        return HEADER_ONLY_TYPES;
    }

    @Override
    public List<URI> getUserTypes() {
        return Collections.emptyList();
    }

    @Override
    public Stream<FedoraResource> getChildren(Boolean recursive) {
        return this.getVersions().stream().map(version -> {
            try {
                FedoraId fedoraId = this.getInstantFedoraId((Instant)version);
                return this.resourceFactory.getResource(this.txId, fedoraId);
            }
            catch (PathNotFoundException e) {
                throw new PathNotFoundRuntimeException(e.getMessage(), (Throwable)e);
            }
        });
    }

    @Override
    public FedoraResource getOriginalResource() {
        return this.originalResource;
    }

    @Override
    public boolean isOriginalResource() {
        return false;
    }

    @Override
    public TimeMap getTimeMap() {
        return this;
    }

    private List<Instant> getVersions() {
        if (this.versions == null) {
            try {
                this.versions = this.getSession().listVersions(this.getFedoraId().asResourceId());
            }
            catch (PersistentItemNotFoundException e) {
                throw new ItemNotFoundException("Unable to retrieve versions for " + this.getId(), (Throwable)e);
            }
            catch (PersistentStorageException e) {
                throw new RepositoryRuntimeException(e.getMessage(), (Throwable)e);
            }
        }
        return this.versions;
    }

    private Resource asResource(FedoraResource fedoraResource) {
        return org.apache.jena.rdf.model.ResourceFactory.createResource((String)fedoraResource.getFedoraId().getFullId());
    }

    private FedoraId getInstantFedoraId(Instant version) {
        return this.getFedoraId().asMemento(version);
    }

    public List<Instant> listMementoDatetimes() {
        return this.getVersions();
    }
}

