/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.observer;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.google.common.eventbus.EventBus;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.observer.Event;
import org.fcrepo.kernel.api.observer.EventAccumulator;
import org.fcrepo.kernel.api.operations.ResourceOperation;
import org.fcrepo.kernel.impl.observer.EventBuilder;
import org.fcrepo.kernel.impl.observer.ResourceOperationEventBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EventAccumulatorImpl
implements EventAccumulator {
    private static final Logger LOG = LoggerFactory.getLogger(EventAccumulatorImpl.class);
    private final Map<String, Multimap<FedoraId, EventBuilder>> transactionEventMap = new ConcurrentHashMap<String, Multimap<FedoraId, EventBuilder>>();
    @Inject
    private ResourceFactory resourceFactory;
    @Inject
    private EventBus eventBus;

    public void recordEventForOperation(String transactionId, FedoraId fedoraId, ResourceOperation operation) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)transactionId), (Object)"transactionId cannot be blank");
        Preconditions.checkNotNull((Object)fedoraId, (Object)"fedoraId cannot be null");
        Multimap events = this.transactionEventMap.computeIfAbsent(transactionId, key -> MultimapBuilder.hashKeys().arrayListValues().build());
        ResourceOperationEventBuilder eventBuilder = ResourceOperationEventBuilder.fromResourceOperation(fedoraId, operation);
        events.put((Object)fedoraId, (Object)eventBuilder);
    }

    public void emitEvents(String transactionId, String baseUrl, String userAgent) {
        LOG.debug("Emitting events for transaction {}", (Object)transactionId);
        Multimap<FedoraId, EventBuilder> eventMap = this.transactionEventMap.remove(transactionId);
        if (eventMap != null) {
            eventMap.keySet().forEach(fedoraId -> {
                Collection events = eventMap.get(fedoraId);
                try {
                    EventBuilder mergedBuilder = (EventBuilder)events.stream().reduce(EventBuilder::merge).get();
                    Event event = mergedBuilder.withResourceTypes(this.loadResourceTypes((FedoraId)fedoraId)).withBaseUrl(baseUrl).withUserAgent(userAgent).build();
                    LOG.debug("Emitting event: {}", (Object)event);
                    this.eventBus.post((Object)event);
                }
                catch (Exception e) {
                    LOG.error("Failed to emit events: {}", (Object)events, (Object)e);
                }
            });
        }
    }

    public void clearEvents(String transactionId) {
        LOG.trace("Clearing events for transaction {}", (Object)transactionId);
        this.transactionEventMap.remove(transactionId);
    }

    private Set<String> loadResourceTypes(FedoraId fedoraId) {
        try {
            return this.resourceFactory.getResource(fedoraId).getTypes().stream().map(URI::toString).collect(Collectors.toSet());
        }
        catch (Exception e) {
            LOG.debug("Could not load resource types for {}", (Object)fedoraId, (Object)e);
            return Collections.emptySet();
        }
    }
}

