/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.operations;

import java.time.Instant;
import java.util.Date;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.fcrepo.kernel.api.RdfLexicon;
import org.fcrepo.kernel.api.RdfStream;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.operations.RdfSourceOperationBuilder;

public abstract class AbstractRdfSourceOperationBuilder
implements RdfSourceOperationBuilder {
    protected RdfStream tripleStream;
    protected final FedoraId resourceId;
    protected final String interactionModel;
    protected String userPrincipal;
    protected String lastModifiedBy;
    protected String createdBy;
    protected Instant lastModifiedDate;
    protected Instant createdDate;

    protected AbstractRdfSourceOperationBuilder(FedoraId rescId, String model) {
        this.resourceId = rescId;
        this.interactionModel = model;
    }

    public RdfSourceOperationBuilder userPrincipal(String userPrincipal) {
        this.userPrincipal = userPrincipal;
        return this;
    }

    public RdfSourceOperationBuilder triples(RdfStream triples) {
        this.tripleStream = triples;
        return this;
    }

    public RdfSourceOperationBuilder relaxedProperties(Model model) {
        if (model != null && AbstractRdfSourceOperationBuilder.isRelaxed()) {
            String modifiedBy;
            Instant modifiedDate;
            String createdByVal;
            Resource resc = model.getResource(this.resourceId.getResourceId());
            Instant createdDateVal = AbstractRdfSourceOperationBuilder.getPropertyAsInstant(resc, RdfLexicon.CREATED_DATE);
            if (createdDateVal != null) {
                this.createdDate = createdDateVal;
            }
            if ((createdByVal = AbstractRdfSourceOperationBuilder.getStringProperty(resc, RdfLexicon.CREATED_BY)) != null) {
                this.createdBy = createdByVal;
            }
            if ((modifiedDate = AbstractRdfSourceOperationBuilder.getPropertyAsInstant(resc, RdfLexicon.LAST_MODIFIED_DATE)) != null) {
                this.lastModifiedDate = modifiedDate;
            }
            if ((modifiedBy = AbstractRdfSourceOperationBuilder.getStringProperty(resc, RdfLexicon.LAST_MODIFIED_BY)) != null) {
                this.lastModifiedBy = modifiedBy;
            }
        }
        return this;
    }

    private static String getStringProperty(Resource resc, Property property) {
        if (resc.hasProperty(property)) {
            return resc.getProperty(property).getString();
        }
        return null;
    }

    private static Instant getPropertyAsInstant(Resource resc, Property property) {
        Object literalValue;
        RDFNode propObj;
        if (resc.hasProperty(property) && (propObj = resc.getProperty(property).getObject()).isLiteral() && (literalValue = propObj.asLiteral().getValue()) instanceof Date) {
            return ((Date)literalValue).toInstant();
        }
        return null;
    }

    private static boolean isRelaxed() {
        return "relaxed".equals(System.getProperty("fcrepo.properties.management"));
    }
}

