/*
 * Decompiled with CFR 0.152.
 */
package org.fcrepo.kernel.impl.services;

import java.util.stream.Stream;
import javax.inject.Inject;
import org.fcrepo.kernel.api.Transaction;
import org.fcrepo.kernel.api.exception.PathNotFoundException;
import org.fcrepo.kernel.api.exception.PathNotFoundRuntimeException;
import org.fcrepo.kernel.api.exception.RepositoryRuntimeException;
import org.fcrepo.kernel.api.identifiers.FedoraId;
import org.fcrepo.kernel.api.models.Binary;
import org.fcrepo.kernel.api.models.Container;
import org.fcrepo.kernel.api.models.FedoraResource;
import org.fcrepo.kernel.api.models.NonRdfSourceDescription;
import org.fcrepo.kernel.api.models.ResourceFactory;
import org.fcrepo.kernel.api.models.Tombstone;
import org.fcrepo.kernel.impl.services.AbstractService;
import org.fcrepo.persistence.api.PersistentStorageSession;
import org.fcrepo.persistence.api.PersistentStorageSessionManager;
import org.fcrepo.persistence.api.exceptions.PersistentStorageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractDeleteResourceService
extends AbstractService {
    private static final Logger log = LoggerFactory.getLogger(AbstractDeleteResourceService.class);
    @Inject
    protected ResourceFactory resourceFactory;
    @Inject
    protected PersistentStorageSessionManager psManager;

    public void perform(Transaction tx, FedoraResource fedoraResource, String userPrincipal) {
        String fedoraResourceId = fedoraResource.getId();
        if (fedoraResource instanceof NonRdfSourceDescription) {
            throw new RepositoryRuntimeException(String.format("A NonRdfSourceDescription cannot be deleted independently of the NonRDFSource:  %s", fedoraResourceId));
        }
        try {
            log.debug("operating on {}", (Object)fedoraResourceId);
            PersistentStorageSession pSession = this.psManager.getSession(tx.getId());
            this.deleteDepthFirst(tx, pSession, fedoraResource, userPrincipal);
        }
        catch (PersistentStorageException ex) {
            throw new RepositoryRuntimeException(String.format("failed to delete/purge resource %s", fedoraResourceId), (Throwable)ex);
        }
    }

    private void deleteDepthFirst(Transaction tx, PersistentStorageSession pSession, FedoraResource fedoraResource, String userPrincipal) throws PersistentStorageException {
        FedoraResource acl;
        FedoraId fedoraId = fedoraResource.getFedoraId();
        if (fedoraResource instanceof Container) {
            Stream<String> children = this.getContained(tx, fedoraResource);
            children.forEach(childResourceId -> {
                try {
                    FedoraResource res = this.resourceFactory.getResource(tx, FedoraId.create((String[])new String[]{childResourceId}));
                    if (res instanceof Tombstone) {
                        this.deleteDepthFirst(tx, pSession, ((Tombstone)res).getDeletedObject(), userPrincipal);
                    } else {
                        this.deleteDepthFirst(tx, pSession, res, userPrincipal);
                    }
                }
                catch (PathNotFoundException ex) {
                    log.error("Path not found for {}: {}", (Object)fedoraId.getFullId(), (Object)ex.getMessage());
                    throw new PathNotFoundRuntimeException(ex.getMessage(), (Throwable)ex);
                }
                catch (PersistentStorageException ex) {
                    throw new RepositoryRuntimeException(String.format("failed to delete resource %s", fedoraId.getFullId()), (Throwable)ex);
                }
            });
        } else if (fedoraResource instanceof Binary) {
            this.doAction(tx, pSession, fedoraResource.getDescription().getFedoraId(), userPrincipal);
        }
        if (!fedoraResource.isAcl() && (acl = fedoraResource.getAcl()) != null) {
            this.doAction(tx, pSession, acl.getFedoraId(), userPrincipal);
        }
        this.doAction(tx, pSession, fedoraId, userPrincipal);
    }

    protected abstract Stream<String> getContained(Transaction var1, FedoraResource var2);

    protected abstract void doAction(Transaction var1, PersistentStorageSession var2, FedoraId var3, String var4) throws PersistentStorageException;
}

